/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;

public class GenericAudioPreparator
extends AbstractPreparator {
    public GenericAudioPreparator() throws RegainException {
        super(new String[]{"audio/mp4", "application/x-ogg", "audio/flac"});
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        File rawFile = rawDocument.getContentAsFile(false);
        try {
            this.prepareFile(rawFile, rawDocument.getUrl());
        }
        catch (ReadOnlyFileException ex) {
            try {
                File tempFile = File.createTempFile(rawFile.getName(), ".mp3");
                RegainToolkit.copyFile((File)rawFile, (File)tempFile);
                this.prepareFile(tempFile, rawDocument.getUrl());
                if (!tempFile.delete()) {
                    tempFile.deleteOnExit();
                }
            }
            catch (ReadOnlyFileException e) {
                throw new RegainException("Error handling audio file: " + rawDocument.getUrl(), (Throwable)e);
            }
            catch (IOException e) {
                throw new RegainException("Error handling audio file: " + rawDocument.getUrl(), (Throwable)e);
            }
        }
    }

    protected void prepareFile(File rawFile, String origUrl) throws RegainException, ReadOnlyFileException {
        try {
            AudioFile audioFile = AudioFileIO.read(rawFile);
            ArrayList<String> info = new ArrayList<String>();
            Tag tag = audioFile.getTag();
            info.add(tag.getFirst(FieldKey.ARTIST).trim());
            info.add(tag.getFirst(FieldKey.ALBUM).trim());
            info.add(tag.getFirst(FieldKey.TITLE).trim());
            try {
                int year = new Integer(tag.getFirst(FieldKey.YEAR).trim());
                if (year > 0) {
                    info.add(tag.getFirst(FieldKey.YEAR).trim());
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            int length = audioFile.getAudioHeader().getTrackLength();
            int hours = length / 3600;
            int minutes = (length -= hours * 3600) / 60;
            int seconds = length -= minutes * 60;
            DecimalFormat doubleDigit = new DecimalFormat("00");
            String res = "";
            if (hours > 0) {
                res = doubleDigit.format(hours) + ":";
            }
            res = res + doubleDigit.format(minutes) + ":";
            res = res + doubleDigit.format(seconds);
            info.add(res);
            info.add(audioFile.getAudioHeader().getBitRate().trim() + "kbps");
            this.setCleanedContent(this.concatenateStringParts(info, Integer.MAX_VALUE));
            this.setTitle(this.concatenateStringParts(info, 2));
        }
        catch (CannotReadException ex) {
            throw new RegainException("Error handling audio file: " + origUrl, (Throwable)ex);
        }
        catch (TagException ex) {
            throw new RegainException("Error handling audio file: " + origUrl, (Throwable)ex);
        }
        catch (InvalidAudioFrameException ex) {
            throw new RegainException("Error handling audio file: " + origUrl, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new RegainException("Error handling audio file: " + origUrl, (Throwable)ex);
        }
    }
}

