/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.config.PreparatorConfig;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class ExternalPreparator
extends AbstractPreparator {
    private String[] mCommandLineArr;
    private RE[] mUrlRegexArr;
    private boolean[] mCheckExitCodeArr;

    public ExternalPreparator() throws RegainException {
        super("");
    }

    public void init(PreparatorConfig config) throws RegainException {
        Map[] commandArr = config.getSectionsWithName("command");
        this.mCommandLineArr = new String[commandArr.length];
        this.mUrlRegexArr = new RE[commandArr.length];
        this.mCheckExitCodeArr = new boolean[commandArr.length];
        for (int i = 0; i < commandArr.length; ++i) {
            String urlPattern = (String)commandArr[i].get("urlPattern");
            String commandLine = (String)commandArr[i].get("commandLine");
            String checkExitCode = (String)commandArr[i].get("checkExitCode");
            if (urlPattern == null) {
                throw new RegainException("Error in ExternalPreparator config: No urlPattern defined in command section #" + (i + 1));
            }
            if (commandLine == null) {
                throw new RegainException("Error in ExternalPreparator config: No commandLine defined in command section #" + (i + 1));
            }
            try {
                this.mUrlRegexArr[i] = new RE(urlPattern);
            }
            catch (RESyntaxException exc) {
                throw new RegainException("Error in ExternalPreparator config: urlPattern has wrong syntax: " + urlPattern, (Throwable)exc);
            }
            this.mCommandLineArr[i] = commandLine;
            this.mCheckExitCodeArr[i] = checkExitCode == null ? true : checkExitCode.equals("true");
        }
    }

    public boolean accepts(RawDocument rawDocument) {
        for (int i = 0; i < this.mUrlRegexArr.length; ++i) {
            if (!this.mUrlRegexArr[i].match(rawDocument.getUrl())) continue;
            return true;
        }
        return false;
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        String commandLine = null;
        boolean checkExitCode = true;
        for (int i = 0; i < this.mUrlRegexArr.length; ++i) {
            if (!this.mUrlRegexArr[i].match(rawDocument.getUrl())) continue;
            commandLine = this.mCommandLineArr[i];
            checkExitCode = this.mCheckExitCodeArr[i];
            break;
        }
        if (commandLine == null) {
            throw new RegainException("Running external command failed: no Regex matched, so I don't know which command to use.");
        }
        String filename = rawDocument.getContentAsFile().getAbsolutePath();
        String cmd = RegainToolkit.replace(commandLine, (String)"${filename}", (String)filename);
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            InputStream stream = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringWriter writer = new StringWriter();
            RegainToolkit.pipe((Reader)reader, (Writer)writer);
            stream.close();
            reader.close();
            writer.close();
            if (checkExitCode) {
                int exitCode;
                try {
                    exitCode = process.waitFor();
                }
                catch (InterruptedException exc2) {
                    throw new RegainException("Waiting for termination of external command failed: " + cmd, (Throwable)exc2);
                }
                if (exitCode != 0) {
                    throw new RegainException("External command returned exit code " + exitCode + ": '" + cmd + "'");
                }
            }
            String cleanedContent = writer.toString();
            this.setCleanedContent(cleanedContent);
        }
        catch (IOException exc) {
            throw new RegainException("Running external command failed: '" + cmd + "'", (Throwable)exc);
        }
    }
}

