/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.plugin.plugin;

import java.io.File;
import java.util.Map;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.config.PreparatorConfig;
import net.sf.regain.crawler.plugin.AbstractCrawlerPlugin;
import org.apache.log4j.Logger;

public class FilesizeFilterPlugin
extends AbstractCrawlerPlugin {
    private static final long NO_MINIMUM_FILESIZE = 0L;
    private static final long NO_MAXIMUM_FILESIZE = -1L;
    private static Logger mLog = Logger.getLogger(FilesizeFilterPlugin.class);
    private long paramFilesizeMinimum = 0L;
    private long paramFilesizeMaximum = -1L;
    private boolean pluginEnabled = false;

    public void init(PreparatorConfig config) throws RegainException {
        Map pluginConfig = config.getSectionWithName("limits");
        if (pluginConfig != null) {
            try {
                this.paramFilesizeMinimum = Integer.valueOf((String)pluginConfig.get("filesizeMinimumBytes")).intValue();
            }
            catch (NumberFormatException e) {
                mLog.warn((Object)"Could not parse minimum filesize, using default (0, no minimum size)");
            }
            try {
                this.paramFilesizeMaximum = Integer.valueOf((String)pluginConfig.get("filesizeMaximumBytes")).intValue();
            }
            catch (NumberFormatException e) {
                mLog.warn((Object)"Could not parse minimum filesize, using default (-1, no maximum size)");
            }
        }
        if (this.paramFilesizeMinimum > 0L || this.paramFilesizeMaximum > -1L) {
            this.pluginEnabled = true;
        }
    }

    public boolean checkDynamicBlacklist(String url, String sourceUrl, String sourceLinkText) {
        if (!this.pluginEnabled) {
            return false;
        }
        File file = null;
        try {
            file = RegainToolkit.urlToFile((String)url);
        }
        catch (RegainException e) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        long filesize = file.length();
        if (this.paramFilesizeMinimum > 0L && filesize < this.paramFilesizeMinimum) {
            return true;
        }
        return this.paramFilesizeMaximum > -1L && filesize > this.paramFilesizeMaximum;
    }
}

