/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.CrawlerToolkit;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;

public class OpenOfficePreparator
extends AbstractPreparator {
    public OpenOfficePreparator() throws RegainException {
        super(new String[]{"application/vnd.sun.xml.writer", "application/vnd.sun.xml.writer.template", "application/vnd.sun.xml.writer.global", "application/vnd.sun.xml.calc", "application/vnd.sun.xml.calc.template", "application/vnd.stardivision.calc", "application/vnd.sun.xml.impress", "application/vnd.sun.xml.impress.template ", "application/vnd.stardivision.impress sdd", "application/vnd.sun.xml.draw", "application/vnd.sun.xml.draw.template", "application/vnd.stardivision.draw", "application/vnd.sun.xml.math", "application/vnd.stardivision.math", "application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/vnd.oasis.opendocument.text-web", "application/vnd.oasis.opendocument.text-master", "application/vnd.oasis.opendocument.graphics", "application/vnd.oasis.opendocument.graphics-template", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.presentation-template", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template", "application/vnd.oasis.opendocument.chart", "application/vnd.oasis.opendocument.formula", "application/vnd.oasis.opendocument.database", "application/vnd.oasis.opendocument.image"});
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        String content;
        ZipFile zipFile;
        File file = rawDocument.getContentAsFile();
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException exc) {
            throw new RegainException("Opening OpenOffice file failed: " + file.getAbsolutePath(), (Throwable)exc);
        }
        ZipEntry entry = zipFile.getEntry("content.xml");
        if (entry == null) {
            throw new RegainException("Opening OpenOffice file failed (no content.xml found inside): " + file.getAbsolutePath());
        }
        InputStream xmlStream = null;
        try {
            xmlStream = zipFile.getInputStream(entry);
            content = RegainToolkit.readStringFromStream((InputStream)xmlStream, (String)"UTF-8");
        }
        catch (IOException exc) {
            throw new RegainException("Reading text from OpenOffice file failed: " + file.getAbsolutePath(), (Throwable)exc);
        }
        finally {
            if (xmlStream != null) {
                try {
                    xmlStream.close();
                }
                catch (IOException exc) {}
            }
            try {
                zipFile.close();
            }
            catch (IOException exc) {}
        }
        String cleanedContent = CrawlerToolkit.cleanFromHtmlTags((String)content);
        this.setCleanedContent(cleanedContent);
    }
}

