/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites.delicious;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataAccessorFactory;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FilterAccessData;
import org.semanticdesktop.aperture.crawler.web.CrawlJob;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NAO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.websites.AbstractTagCrawler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliciousCrawler
extends AbstractTagCrawler {
    private Logger log = LoggerFactory.getLogger(DeliciousCrawler.class);
    public static final String TAGS_API = "del.icio.us/api/tags/get";
    public static final String POSTS_API = "del.icio.us/api/posts/all";
    private WebAccessData wad = null;
    private LinkedList<CrawlJob> jobsQueue;
    private HashMap<String, CrawlJob> jobsMap;

    public DeliciousCrawler(DataSource dataSource) {
        this.setDataSource(dataSource);
        this.jobsQueue = new LinkedList();
        this.jobsMap = new HashMap(1024);
    }

    @Override
    protected List<String> crawlTags(String username, String password) throws Exception {
        String url = "http://del.icio.us/api/tags/get";
        System.out.println(url);
        Vector<String> res = new Vector<String>();
        UsernamePasswordCredentials c = new UsernamePasswordCredentials(username, password);
        HttpClient hc = new HttpClient();
        hc.getState().setCredentials(AuthScope.ANY, (Credentials)c);
        GetMethod method = new GetMethod(url);
        method.setDoAuthentication(true);
        int http_code = hc.executeMethod((HttpMethod)method);
        if (http_code != 200) {
            throw new Exception("HTTP Method did not return OK for url '" + url + "' code: " + http_code);
        }
        Document d = this.getDocument(method.getResponseBodyAsStream());
        NodeList l = d.getElementsByTagName("tag");
        int i = 0;
        while (l.item(i) != null) {
            Element e = (Element)l.item(i);
            res.add("http://del.icio.us/" + username + "/" + e.getAttribute("tag"));
            ++i;
        }
        return res;
    }

    @Override
    protected void crawlTheRest(String username, String pass) throws SAXException, Exception {
        String url = "http://del.icio.us/api/posts/all";
        System.out.println(url);
        DataSource localSource = this.getDataSource();
        UsernamePasswordCredentials c = new UsernamePasswordCredentials(username, pass);
        HttpClient hc = new HttpClient();
        hc.getState().setCredentials(AuthScope.ANY, (Credentials)c);
        GetMethod method = new GetMethod(url);
        method.setDoAuthentication(true);
        int http_code = hc.executeMethod((HttpMethod)method);
        if (http_code != 200) {
            throw new Exception("HTTP Method did not return OK for url '" + url + "' code: " + http_code);
        }
        Document d = this.getDocument(method.getResponseBodyAsStream());
        NodeList l = d.getElementsByTagName("post");
        int i = 0;
        while (l.item(i) != null) {
            Element e = (Element)l.item(i);
            String postHref = e.getAttribute("href");
            URIImpl postURI = new URIImpl(postHref);
            if (this.accessData.isKnownId(postHref)) {
                this.reportUnmodifiedDataObject(postHref);
            } else {
                RDFContainer rdf;
                DataObject o;
                this.accessData.put(postHref, "date", Long.toString(new Date().getTime()));
                DataAccessor accessor = this.getDataAccessor(postHref);
                RDFContainerFactory containerFactory = this.getRDFContainerFactory(postHref);
                try {
                    o = accessor.getDataObject(postHref, this.source, null, containerFactory);
                    rdf = o.getMetadata();
                }
                catch (Throwable ex) {
                    this.log.debug("Could not crawl web-site, continuing. ", ex);
                    rdf = this.getRDFContainerFactory(postHref).getRDFContainer(postURI);
                    o = new DataObjectBase(postURI, this.source, rdf);
                }
                rdf.add(RDF.type, NFO.Website);
                String tags = e.getAttribute("tag");
                for (String tag : tags.split(" ")) {
                    rdf.add(NAO.hasTag, new URIImpl("http://del.icio.us/" + username + "/" + tag));
                }
                this.reportNewDataObject(o);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument(InputStream in) throws IOException, ParserConfigurationException, SAXException {
        Document result = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setSchema(null);
        try {
            in = new BufferedInputStream(in);
            DocumentBuilder builder = factory.newDocumentBuilder();
            result = builder.parse(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return result;
    }

    private DataAccessor getDataAccessor(String url) {
        int index = url.indexOf(58);
        if (index <= 0) {
            return null;
        }
        String scheme = url.substring(0, index);
        Set factories = this.accessorRegistry.get(scheme);
        if (factories.isEmpty()) {
            return null;
        }
        DataAccessorFactory factory = (DataAccessorFactory)factories.iterator().next();
        return factory.get();
    }

    private class WebAccessData
    extends FilterAccessData {
        public WebAccessData(AccessData accessData) {
            super(accessData);
        }

        public void put(String id, String key, String value) {
            if ("redirectsTo".equals(key)) {
                this.touch(id);
                CrawlJob job = (CrawlJob)DeliciousCrawler.this.jobsMap.remove(id);
                if (job != null) {
                    DeliciousCrawler.this.jobsQueue.remove(job);
                }
            }
            super.put(id, key, value);
        }
    }
}

