/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites.bibsonomy;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bibsonomy.common.enums.GroupingEntity;
import org.bibsonomy.model.BibTex;
import org.bibsonomy.model.PersonName;
import org.bibsonomy.model.Post;
import org.bibsonomy.model.Resource;
import org.bibsonomy.model.Tag;
import org.bibsonomy.rest.client.AbstractQuery;
import org.bibsonomy.rest.client.Bibsonomy;
import org.bibsonomy.rest.client.exception.ErrorPerformingRequestException;
import org.bibsonomy.rest.client.queries.get.GetPostsQuery;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NAO;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.vocabulary.SWRC;
import org.semanticdesktop.aperture.websites.bibsonomy.BibsonomyDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BibsonomyCrawler
extends CrawlerBase {
    private static final String API_URL = "http://www.bibsonomy.org/api";
    private static final String USERS_API_URL = "http://www.bibsonomy.org/api/users/";
    private static final String TAGS_API_URL = "http://www.bibsonomy.org/api/tags/";
    private static final Map<String, URI> bibtexTypesToSwrcTypes = new HashMap<String, URI>();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    protected ExitCode crawlObjects() {
        BibsonomyDataSource ds = (BibsonomyDataSource)this.source;
        String username = ds.getApiusername();
        String apikey = ds.getApikey();
        String crawledUser = ds.getCrawledusername();
        if (username == null || apikey == null) {
            throw new NullPointerException("apiusername, apikey and crawledusername must not be null");
        }
        Bibsonomy bib = new Bibsonomy(username, apikey);
        bib.setApiURL(API_URL);
        int start = 0;
        int found = 0;
        do {
            GetPostsQuery q = new GetPostsQuery(start, start + 50);
            start += 50;
            q.setGrouping(GroupingEntity.USER, crawledUser);
            q.setResourceType(BibTex.class);
            try {
                bib.executeQuery((AbstractQuery)q);
                if (q.getHttpStatusCode() == 200) {
                    List posts = q.getResult();
                    found = posts.size();
                    for (Post post : posts) {
                        Resource res = post.getResource();
                        if (!(res instanceof BibTex)) continue;
                        this.processSingleBibtexEntry((Post<? extends Resource>)post, (BibTex)res);
                    }
                    continue;
                }
                return this.reportFatalErrorCause("Couldn't get data from Bibsonomy. Status code: " + q.getHttpStatusCode() + " error: " + q.getError());
            }
            catch (IllegalStateException e) {
                this.reportFatalErrorCause("Couldn't get data from Bibsonomy", e);
                return ExitCode.FATAL_ERROR;
            }
            catch (ErrorPerformingRequestException e) {
                this.reportFatalErrorCause("Couldn't get data from Bibsonomy", e);
                return ExitCode.FATAL_ERROR;
            }
        } while (found == 50);
        return ExitCode.COMPLETED;
    }

    private void processSingleBibtexEntry(Post<? extends Resource> post, BibTex res) {
        URI bibtexUri = BibsonomyCrawler.getBibtexUri(post, res);
        if (this.accessData != null && this.accessData.isKnownId(bibtexUri.toString())) {
            this.reportUnmodifiedDataObject(bibtexUri.toString());
            return;
        }
        RDFContainer cont = this.getRDFContainerFactory(bibtexUri.toString()).getRDFContainer(bibtexUri);
        DataObject object = BibsonomyCrawler.convertBibtexEntryToDataObject(cont, post, res);
        this.reportNewDataObject(object);
    }

    public static DataObject convertBibtexEntryToDataObject(RDFContainer cont, Post<? extends Resource> post, BibTex res) {
        BibsonomyCrawler.addBibtexType(res, cont);
        BibsonomyCrawler.addDateProperty(cont, NIE.contentCreated, post.getDate());
        BibsonomyCrawler.addStringProperty(cont, NIE.description, post.getDescription());
        BibsonomyCrawler.addTagListProperty(cont, NAO.hasTag, post);
        BibsonomyCrawler.addPersonNameListProperty(cont, SWRC.author, res.getAuthorList());
        BibsonomyCrawler.addStringProperty(cont, SWRC.title, res.getTitle());
        BibsonomyCrawler.addStringProperty(cont, SWRC.address, res.getAddress());
        BibsonomyCrawler.addStringProperty(cont, SWRC.abstract_, res.getAbstract());
        BibsonomyCrawler.addStringProperty(cont, SWRC.booktitle, res.getBooktitle());
        BibsonomyCrawler.addStringProperty(cont, SWRC.chapter, res.getChapter());
        BibsonomyCrawler.addBibtexDateProperty(cont, SWRC.date, res);
        BibsonomyCrawler.addStringProperty(cont, SWRC.edition, res.getEdition());
        BibsonomyCrawler.addPersonNameListProperty(cont, SWRC.editor, res.getEditorList());
        BibsonomyCrawler.addStringProperty(cont, SWRC.howpublished, res.getHowpublished());
        BibsonomyCrawler.addStringProperty(cont, SWRC.institution, res.getInstitution());
        BibsonomyCrawler.addStringProperty(cont, SWRC.journal, res.getJournal());
        BibsonomyCrawler.addStringProperty(cont, SWRC.note, res.getNote());
        BibsonomyCrawler.addStringProperty(cont, SWRC.number, res.getNumber());
        BibsonomyCrawler.addStringProperty(cont, SWRC.organization, res.getOrganization());
        BibsonomyCrawler.addStringProperty(cont, SWRC.pages, res.getPages());
        BibsonomyCrawler.addStringProperty(cont, SWRC.publisher, res.getPublisher());
        BibsonomyCrawler.addStringProperty(cont, SWRC.school, res.getSchool());
        BibsonomyCrawler.addStringProperty(cont, SWRC.series, res.getSeries());
        BibsonomyCrawler.addStringProperty(cont, SWRC.volume, res.getVolume());
        return new DataObjectBase(cont.getDescribedUri(), null, cont);
    }

    private static void addBibtexType(BibTex res, RDFContainer cont) {
        String type = res.getType();
        URI swrcType = null;
        if (type != null) {
            swrcType = bibtexTypesToSwrcTypes.get(res.getType());
        }
        if (swrcType != null) {
            cont.add(RDF.type, swrcType);
        } else {
            cont.add(RDF.type, SWRC.Publication);
        }
    }

    private static void addStringProperty(RDFContainer cont, URI property, String string) {
        if (string != null && string.trim().length() > 0) {
            cont.add(property, BibsonomyCrawler.stripBraces(string));
        }
    }

    private static void addDateProperty(RDFContainer cont, URI property, Date date) {
        if (date != null) {
            cont.add(property, date);
        }
    }

    private static void addPersonNameListProperty(RDFContainer cont, URI property, List<PersonName> list) {
        URIImpl previousLink = null;
        Model model = cont.getModel();
        for (PersonName pName : list) {
            URIImpl authorUri = new URIImpl("uri:" + UUID.randomUUID().toString());
            model.addStatement(authorUri, RDF.type, NCO.Contact);
            model.addStatement(authorUri, NCO.fullname, pName.getName());
            URIImpl uri = new URIImpl("uri:" + UUID.randomUUID().toString());
            model.addStatement(uri, RDF.type, RDF.List);
            model.addStatement(uri, RDF.first, authorUri);
            if (previousLink == null) {
                model.addStatement(cont.getDescribedUri(), property, uri);
            } else {
                model.addStatement(previousLink, RDF.rest, uri);
            }
            previousLink = uri;
        }
        if (previousLink != null) {
            model.addStatement(previousLink, RDF.rest, RDF.nil);
        }
    }

    private static void addTagListProperty(RDFContainer cont, URI property, Post<? extends Resource> post) {
        Model model = cont.getModel();
        for (Tag tag : post.getTags()) {
            URI tagUri = model.createURI(TAGS_API_URL + tag.getName());
            model.addStatement(tagUri, RDF.type, NAO.Tag);
            model.addStatement(cont.getDescribedUri(), property, tagUri);
        }
    }

    private static void addBibtexDateProperty(RDFContainer cont, URI property, BibTex res) {
        GregorianCalendar cal = new GregorianCalendar(1, 1, 1);
        if (res.getYear() != null) {
            try {
                cal.set(1, Integer.parseInt(res.getYear()));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (res.getMonth() != null) {
            try {
                cal.set(2, Integer.parseInt(res.getMonth()));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (res.getDay() != null) {
            try {
                cal.set(5, Integer.parseInt(res.getDay()));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (cal.get(1) > 1) {
            cont.add(property, new Date(cal.getTimeInMillis()));
        }
    }

    public static URI getBibtexUri(Post<? extends Resource> post, BibTex res) {
        return new URIImpl(USERS_API_URL + post.getUser().getName() + "/posts/" + res.getIntraHash());
    }

    private static String stripBraces(String in) {
        if (in == null || in.length() < 2) {
            return in;
        }
        if (in.charAt(0) == '{' && in.charAt(in.length() - 1) == '}') {
            return in.substring(1, in.length() - 2);
        }
        return in;
    }

    static {
        bibtexTypesToSwrcTypes.put("article", SWRC.Article);
        bibtexTypesToSwrcTypes.put("book", SWRC.Book);
        bibtexTypesToSwrcTypes.put("booklet", SWRC.Booklet);
        bibtexTypesToSwrcTypes.put("inbook", SWRC.InBook);
        bibtexTypesToSwrcTypes.put("incollection", SWRC.InCollection);
        bibtexTypesToSwrcTypes.put("inproceedings", SWRC.InProceedings);
        bibtexTypesToSwrcTypes.put("manual", SWRC.Manual);
        bibtexTypesToSwrcTypes.put("mastersthesis", SWRC.MasterThesis);
        bibtexTypesToSwrcTypes.put("misc", SWRC.Misc);
        bibtexTypesToSwrcTypes.put("phdthesis", SWRC.PhDThesis);
        bibtexTypesToSwrcTypes.put("proceedings", SWRC.Proceedings);
        bibtexTypesToSwrcTypes.put("techreport", SWRC.TechnicalReport);
        bibtexTypesToSwrcTypes.put("unpublished", SWRC.Unpublished);
    }
}

