/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.List;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.config.ConfigurationUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.UpdateException;
import org.semanticdesktop.aperture.vocabulary.NAO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.websites.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTagCrawler
extends CrawlerBase {
    Logger log = LoggerFactory.getLogger(AbstractTagCrawler.class);

    @Override
    protected ExitCode crawlObjects() {
        DataSource localSource = this.getDataSource();
        RDFContainer configuration = localSource.getConfiguration();
        String username = ConfigurationUtil.getUsername(configuration);
        String password = ConfigurationUtil.getPassword(configuration);
        try {
            List<String> tags = this.crawlTags(username, password);
            for (String t : tags) {
                URIImpl turi = new URIImpl(t);
                if (this.accessData.isKnownId(t)) {
                    this.reportUnmodifiedDataObject(t);
                    continue;
                }
                this.accessData.put(t, "date", Long.toString(new Date().getTime()));
                RDFContainer rdf = this.getRDFContainerFactory(t).getRDFContainer(turi);
                DataObjectBase o = new DataObjectBase(turi, localSource, rdf);
                rdf.add(RDF.type, NAO.Tag);
                rdf.add(NIE.rootElementOf, this.getDataSource().getID());
                rdf.add(RDFS.label, URLDecoder.decode(this.getShortName(((Object)turi).toString()), "utf-8"));
                this.reportNewDataObject(o);
            }
            this.crawlTheRest(username, password);
        }
        catch (Exception e) {
            return this.reportFatalErrorCause("Could not crawl tag-datasource.", e);
        }
        return this.stopRequested ? ExitCode.STOP_REQUESTED : ExitCode.COMPLETED;
    }

    protected void crawlTheRest(String username, String password) throws Exception {
    }

    protected void reportItem(Tag item, List<String> tags) throws UpdateException, UnsupportedEncodingException {
        String uriString = item.getUri();
        if (this.accessData.isKnownId(uriString)) {
            this.reportUnmodifiedDataObject(uriString);
        } else {
            this.accessData.put(uriString, "date", Long.toString(new Date().getTime()));
            URIImpl turi = new URIImpl(uriString);
            RDFContainer rdf = this.getRDFContainerFactory(uriString).getRDFContainer(turi);
            DataObjectBase o = new DataObjectBase(turi, this.source, rdf);
            rdf.add(RDF.type, NFO.Website);
            rdf.add(RDFS.label, URLDecoder.decode(item.getName(), "utf-8"));
            for (String tag : tags) {
                rdf.add(NAO.hasTag, new URIImpl(tag));
            }
            this.reportNewDataObject(o);
        }
    }

    protected abstract List<String> crawlTags(String var1, String var2) throws Exception;

    protected String getShortName(String uri) {
        if (uri.indexOf(35) > 0) {
            uri = uri.substring(uri.lastIndexOf(35) + 1);
        } else if (uri.indexOf(47) > 0) {
            uri = uri.substring(uri.lastIndexOf(47) + 1);
        }
        return uri;
    }
}

