/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamMonitor {
    private StreamConsumer thread;
    private MonitoredStream monitoredStream;
    private long maxProcessingTimePerMb;
    private long minimumMaxProcessingTime;
    private long maxIdleReadTime;
    private volatile boolean suspendMonitoring;

    public StreamMonitor(InputStream stream, StreamConsumerFactory threadFac, StopRequestor stopRequestor, long maxProcessingTimePerMb, long minimumMaxProcessingTime, long maxIdleReadTime) {
        this.monitoredStream = new MonitoredStream(stream, stopRequestor);
        if (threadFac != null) {
            this.thread = threadFac.getConsumer(this.monitoredStream, this);
        }
        this.maxProcessingTimePerMb = maxProcessingTimePerMb;
        this.minimumMaxProcessingTime = minimumMaxProcessingTime;
        this.maxIdleReadTime = maxIdleReadTime;
        this.suspendMonitoring = false;
    }

    public void setStreamConsumerFactory(StreamConsumerFactory abortableThreadFactory) {
        this.thread = abortableThreadFactory.getConsumer(this.monitoredStream, this);
    }

    public void start() throws Exception {
        this.thread.start();
        while (true) {
            long waitTime;
            if (this.monitoredStream.allBytesRead()) {
                waitTime = (long)((double)(this.maxProcessingTimePerMb * (long)this.monitoredStream.getTotalBytesRead()) / 1048576.0);
                waitTime = Math.max(waitTime, this.minimumMaxProcessingTime);
            } else {
                waitTime = this.maxIdleReadTime;
            }
            waitTime -= System.currentTimeMillis() - this.monitoredStream.getLastAccessTime();
            boolean breakCondition = false;
            if (!this.thread.isAlive()) {
                breakCondition = true;
            }
            if (waitTime <= 0L) {
                breakCondition = true;
            }
            if (this.suspendMonitoring) {
                this.safelySleep(1000L);
                continue;
            }
            if (breakCondition) break;
            this.thread.join(waitTime);
        }
        if (this.thread.isAlive()) {
            this.thread.abortProcessing();
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.thread.isAlive()) {
                this.thread.stop();
                try {
                    this.thread.join(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            throw new ProcessingAbortedException();
        }
        Exception e = this.thread.getException();
        if (e != null) {
            throw e;
        }
    }

    public void suspendMonitoring() {
        this.suspendMonitoring = true;
    }

    public void resumeMonitoring() {
        this.monitoredStream.touch();
        this.suspendMonitoring = false;
    }

    private void safelySleep(long ms) {
        long start = System.currentTimeMillis();
        long now = System.currentTimeMillis();
        while (now < start + ms) {
            try {
                Thread.sleep(start + ms - now);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
    }

    private static class MonitoredStream
    extends FilterInputStream {
        private long lastAccessTime;
        private boolean allBytesRead;
        private int totalBytesRead;
        private StopRequestor stopRequestor;

        public MonitoredStream(InputStream in, StopRequestor stopRequestor) {
            super(in);
            this.touch();
            this.allBytesRead = false;
            this.totalBytesRead = 0;
            this.stopRequestor = stopRequestor;
        }

        public synchronized void touch() {
            this.lastAccessTime = System.currentTimeMillis();
        }

        public synchronized long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public boolean allBytesRead() {
            return this.allBytesRead;
        }

        public int getTotalBytesRead() {
            return this.totalBytesRead;
        }

        public int read() throws IOException {
            this.checkStopRequested();
            int result = super.read();
            if (result >= 0) {
                this.touch();
                ++this.totalBytesRead;
            } else {
                this.allBytesRead = true;
            }
            return result;
        }

        public int read(byte[] b) throws IOException {
            this.checkStopRequested();
            int result = super.read(b);
            if (result >= 0) {
                this.touch();
                this.totalBytesRead += result;
            } else {
                this.allBytesRead = true;
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.checkStopRequested();
            int result = super.read(b, off, len);
            if (result >= 0) {
                this.touch();
                this.totalBytesRead += result;
            } else {
                this.allBytesRead = true;
            }
            return result;
        }

        public void close() throws IOException {
            super.close();
            this.allBytesRead = true;
        }

        private void checkStopRequested() throws ProcessingInterruptedException {
            if (this.stopRequestor != null && this.stopRequestor.isStopRequested()) {
                throw new ProcessingInterruptedException();
            }
        }
    }

    public static class ProcessingInterruptedException
    extends IOException {
        private static final long serialVersionUID = 7927176466287498836L;
    }

    public static class ProcessingAbortedException
    extends Exception {
        private static final long serialVersionUID = 5699102874255697906L;
    }

    public static interface StopRequestor {
        public boolean isStopRequested();
    }

    public static interface StreamConsumerFactory {
        public StreamConsumer getConsumer(InputStream var1, StreamMonitor var2);
    }

    public static abstract class StreamConsumer
    extends Thread {
        public abstract void abortProcessing();

        public abstract Exception getException();
    }
}

