/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.StringTokenizer;
import org.semanticdesktop.aperture.util.IOUtil;

public class FileUtil {
    private static final String ILLEGAL_FILE_NAME_CHARS = "\\/:*?\"<>|";

    public static String getRelativePath(File subj, File relativeTo) {
        int idx;
        String subjPath = subj.getAbsolutePath();
        String relativeToPath = relativeTo.getAbsolutePath();
        if (!subj.isDirectory() && (idx = subjPath.lastIndexOf(File.separator)) != -1) {
            subjPath = subjPath.substring(0, idx);
        }
        if (!relativeTo.isDirectory() && (idx = relativeToPath.lastIndexOf(File.separator)) != -1) {
            relativeToPath = relativeToPath.substring(0, idx);
        }
        StringTokenizer subjPathTok = new StringTokenizer(subjPath, File.separator);
        StringTokenizer relativeToPathTok = new StringTokenizer(relativeToPath, File.separator);
        String subjTok = null;
        String relativeToTok = null;
        while (subjPathTok.hasMoreTokens() && relativeToPathTok.hasMoreTokens() && (subjTok = subjPathTok.nextToken()).equals(relativeToTok = relativeToPathTok.nextToken())) {
        }
        StringBuilder relPath = new StringBuilder();
        if (!subjTok.equals(relativeToTok)) {
            relPath.append("..");
            relPath.append(File.separator);
        }
        while (relativeToPathTok.hasMoreTokens()) {
            relativeToPathTok.nextToken();
            relPath.append("..");
            relPath.append(File.separator);
        }
        if (!subjTok.equals(relativeToTok)) {
            relPath.append(subjTok);
            relPath.append(File.separator);
        }
        while (subjPathTok.hasMoreTokens()) {
            subjTok = subjPathTok.nextToken();
            relPath.append(subjTok);
            relPath.append(File.separator);
        }
        relPath.append(subj.getName());
        return relPath.toString();
    }

    public static File getRelativeFile(File subj, File relativeTo) {
        return new File(FileUtil.getRelativePath(subj, relativeTo));
    }

    public static String getFileExtension(String fileName) {
        String extension;
        int lastDotIdx = fileName.lastIndexOf(46);
        if (lastDotIdx > 0 && lastDotIdx < fileName.length() - 1 && FileUtil.isLegalFileName(extension = fileName.substring(lastDotIdx + 1).trim())) {
            return extension;
        }
        return null;
    }

    public static boolean isLegalFileName(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (FileUtil.isLegalFileNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalFileNameChar(char c) {
        return ILLEGAL_FILE_NAME_CHARS.indexOf(c) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File destination) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            IOUtil.writeStream((InputStream)in, destination);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void createDirIfNotExists(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create directory: " + dir.toString());
        }
    }

    public static boolean deltree(File directory) {
        if (directory == null || !directory.exists()) {
            return true;
        }
        boolean result = true;
        if (directory.isFile()) {
            result = directory.delete();
        } else {
            File[] list = directory.listFiles();
            int i = list.length;
            while (i-- > 0) {
                if (FileUtil.deltree(list[i])) continue;
                result = false;
            }
            if (!directory.delete()) {
                result = false;
            }
        }
        return result;
    }

    public static boolean deleteChildren(File directory) {
        boolean result = true;
        if (directory.isDirectory()) {
            File[] list = directory.listFiles();
            int i = list.length;
            while (i-- > 0) {
                result = result && FileUtil.deltree(list[i]);
            }
        }
        return result;
    }

    public static boolean moveRecursive(File from, File to, Collection excludes) {
        if (from == null || !from.exists()) {
            return false;
        }
        boolean result = true;
        if (from.isFile()) {
            if (excludes == null || !excludes.contains(from)) {
                to.getParentFile().mkdirs();
                result = from.renameTo(to);
            }
        } else {
            boolean excludedFileFound = false;
            File[] list = from.listFiles();
            int i = list.length;
            while (i-- > 0) {
                File listItem = list[i];
                if (excludes != null && excludes.contains(listItem)) {
                    excludedFileFound = true;
                    continue;
                }
                if (FileUtil.moveRecursive(listItem, new File(to, listItem.getName()), excludes)) continue;
                result = false;
            }
            if (!excludedFileFound && !from.delete()) {
                result = false;
            }
        }
        return result;
    }

    public static String readWholeFileAsUTF8(String filename) throws IOException {
        return FileUtil.readWholeFileAsEncoding(filename, "utf-8");
    }

    public static String readStreamAsUTF8(InputStream in) throws IOException {
        return FileUtil.readStreamAsEncoding(in, "utf-8");
    }

    public static String readStreamAsEncoding(InputStream in, String encoding) throws IOException {
        int l;
        BufferedReader r = new BufferedReader(FileUtil.asEncoding(in, encoding), 1024);
        StringWriter sw = new StringWriter(1024);
        char[] buff = new char[1024];
        while (((Reader)r).ready() && (l = r.read(buff)) > 0) {
            sw.write(buff, 0, l);
        }
        ((Reader)r).close();
        sw.close();
        return sw.toString();
    }

    public static String readWholeFileAsEncoding(String filename, String encoding) throws IOException {
        FileInputStream in = new FileInputStream(filename);
        return FileUtil.readStreamAsEncoding(in, encoding);
    }

    private static Reader asEncoding(InputStream in, String encoding) {
        Charset charset = Charset.forName(encoding);
        return new InputStreamReader(in, charset.newDecoder());
    }
}

