/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.zip;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.semanticdesktop.aperture.subcrawler.base.AbstractArchiverSubCrawler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSubCrawler
extends AbstractArchiverSubCrawler {
    protected AbstractArchiverSubCrawler.ArchiveInputStream getArchiveInputStream(InputStream in) {
        return new ZipSubCrawlerInputStream(in);
    }

    public String getUriPrefix() {
        return "zip";
    }

    protected static class ZipSubCrawlerJuzEntry
    extends AbstractArchiverSubCrawler.ArchiveEntry {
        private ZipEntry entry;

        public ZipSubCrawlerJuzEntry(ZipEntry entry2) {
            this.entry = entry2;
        }

        public String getPath() {
            return this.entry.getName();
        }

        public String getComment() {
            return this.entry.getComment();
        }

        public long getCompressedSize() {
            return this.entry.getCompressedSize();
        }

        public long getCrc() {
            return this.entry.getCrc();
        }

        public long getLastModificationTime() {
            return this.entry.getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }
    }

    protected static class ZipSubCrawlerEntry
    extends AbstractArchiverSubCrawler.ArchiveEntry {
        private ZipArchiveEntry entry;

        public ZipSubCrawlerEntry(ZipArchiveEntry entry2) {
            this.entry = entry2;
        }

        public String getPath() {
            return this.entry.getName();
        }

        public String getComment() {
            return this.entry.getComment();
        }

        public long getCompressedSize() {
            return this.entry.getCompressedSize();
        }

        public long getCrc() {
            return this.entry.getCrc();
        }

        public long getLastModificationTime() {
            return this.entry.getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public boolean isEncrypted() {
            return this.entry.isEncrypted();
        }
    }

    protected static class ZipSubCrawlerInputStream
    extends AbstractArchiverSubCrawler.ArchiveInputStream {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private boolean first = true;
        private boolean juzFallback = false;

        public ZipSubCrawlerInputStream(InputStream in) {
            super(in);
        }

        public AbstractArchiverSubCrawler.ArchiveEntry getNextEntry() throws IOException {
            if (this.first) {
                this.first = false;
                BufferedInputStream bis = new BufferedInputStream(this.in);
                bis.mark(512);
                this.in = new ZipArchiveInputStream((InputStream)bis);
                try {
                    ZipArchiveEntry entry = ((ZipArchiveInputStream)this.in).getNextZipEntry();
                    return entry == null ? null : new ZipSubCrawlerEntry(entry);
                }
                catch (RuntimeException e) {
                    String msg = e.getMessage();
                    if (msg != null && msg.startsWith("data starting at")) {
                        this.juzFallback = true;
                        bis.reset();
                        this.in = new ZipInputStream(bis);
                        ZipEntry entry = ((ZipInputStream)this.in).getNextEntry();
                        return entry == null ? null : new ZipSubCrawlerJuzEntry(entry);
                    }
                    throw e;
                }
            }
            if (this.juzFallback) {
                ZipEntry entry = ((ZipInputStream)this.in).getNextEntry();
                return entry == null ? null : new ZipSubCrawlerJuzEntry(entry);
            }
            ZipArchiveEntry entry = ((ZipArchiveInputStream)this.in).getNextZipEntry();
            return entry == null ? null : new ZipSubCrawlerEntry(entry);
        }

        public void closeEntry() throws IOException {
        }
    }
}

