/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.tar;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.semanticdesktop.aperture.subcrawler.base.AbstractArchiverSubCrawler;

public class TarSubCrawler
extends AbstractArchiverSubCrawler {
    protected AbstractArchiverSubCrawler.ArchiveInputStream getArchiveInputStream(InputStream in) {
        return new TarSubCrawlerInputStream(in);
    }

    public String getUriPrefix() {
        return "tar";
    }

    protected class TarSubCrawlerEntry
    extends AbstractArchiverSubCrawler.ArchiveEntry {
        private TarArchiveEntry entry;

        public TarSubCrawlerEntry(TarArchiveEntry entry) {
            this.entry = entry;
        }

        public String getPath() {
            return this.entry.getName().replaceAll("//", "/");
        }

        public long getLastModificationTime() {
            return this.entry.getModTime().getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }
    }

    protected class TarSubCrawlerInputStream
    extends AbstractArchiverSubCrawler.ArchiveInputStream {
        public TarSubCrawlerInputStream(InputStream in) {
            super((InputStream)new TarArchiveInputStream(in));
        }

        public AbstractArchiverSubCrawler.ArchiveEntry getNextEntry() throws IOException {
            TarArchiveEntry entry = (TarArchiveEntry)((TarArchiveInputStream)this.in).getNextEntry();
            return entry == null ? null : new TarSubCrawlerEntry(entry);
        }

        public void closeEntry() throws IOException {
        }
    }
}

