/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.mime;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.crawler.mail.DataObjectFactory;
import org.semanticdesktop.aperture.crawler.mail.MailUtil;
import org.semanticdesktop.aperture.crawler.mail.MessageDataObject;
import org.semanticdesktop.aperture.crawler.mail.base.MessageDataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.UpdateException;
import org.semanticdesktop.aperture.rdf.ValueFactory;
import org.semanticdesktop.aperture.subcrawler.PathNotFoundException;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerException;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerHandler;
import org.semanticdesktop.aperture.subcrawler.base.AbstractSubCrawler;
import org.semanticdesktop.aperture.subcrawler.mime.MimeSubCrawlerFactory;

public class MimeSubCrawler
extends AbstractSubCrawler
implements DataObjectFactory.PartStreamFactory {
    private boolean stopRequested;
    private MimeMessage message;

    public void subCrawl(URI id, InputStream stream, SubCrawlerHandler handler, DataSource dataSource, AccessData accessData, Charset charset, String mimeType, RDFContainer parentMetadata) throws SubCrawlerException {
        DataObjectFactory fac = null;
        try {
            this.message = new MimeMessage(null, stream);
            URI attachmentUriPrefix = this.createChildUri(parentMetadata.getDescribedUri(), "");
            FilteringRDFContainerFactory myFac = new FilteringRDFContainerFactory(handler.getRDFContainerFactory(parentMetadata.getDescribedUri().toString()), parentMetadata, parentMetadata.getDescribedUri());
            fac = new DataObjectFactory(this.message, myFac, this, dataSource, parentMetadata.getDescribedUri(), null, "", attachmentUriPrefix.toString());
            DataObject object = null;
            while (!this.stopRequested && (object = fac.getObject()) != null) {
                if (object.getMetadata().getDescribedUri().equals(parentMetadata.getDescribedUri())) {
                    object.dispose();
                    continue;
                }
                String queuedUri = object.getID().toString();
                if (accessData != null && accessData.get(queuedUri, "accessed") != null) {
                    handler.objectChanged(object);
                    continue;
                }
                if (accessData != null) {
                    accessData.put(queuedUri, "accessed", "");
                }
                MailUtil.registerParentRelationshipInAccessData(object, accessData);
                handler.objectNew(object);
            }
        }
        catch (MessagingException e) {
            throw new SubCrawlerException(e);
        }
        catch (IOException e) {
            throw new SubCrawlerException(e);
        }
        finally {
            if (fac != null) {
                fac.disposeRemainingObjects();
            }
        }
    }

    public void stopSubCrawler() {
        this.stopRequested = true;
    }

    public MimeMessage getLastMimeMessage() {
        return this.message;
    }

    public DataObject getDataObject(URI parentUri, String path, InputStream stream, DataSource dataSource, Charset charset, String mimeType, RDFContainerFactory factory) throws SubCrawlerException, PathNotFoundException {
        DataObject result = super.getDataObject(parentUri, path, stream, dataSource, charset, mimeType, factory);
        return result;
    }

    public String getUriPrefix() {
        return MimeSubCrawlerFactory.MIME_URI_PREFIX;
    }

    public InputStream getPartStream(Part part) throws MessagingException, IOException {
        return part.getInputStream();
    }

    public MessageDataObject createDataObject(URI dataObjectId, DataSource dataSource, RDFContainer metadata, MimeMessage msg) throws MessagingException {
        return new MessageDataObjectBase(dataObjectId, dataSource, metadata, msg);
    }

    private static class UndisposableRDFContainer
    implements RDFContainer {
        private RDFContainer wrappedContainer;

        UndisposableRDFContainer(RDFContainer container) {
            this.wrappedContainer = container;
        }

        public void add(Statement statement) throws UpdateException {
            this.wrappedContainer.add(statement);
        }

        public void add(URI property, boolean value) throws UpdateException {
            this.wrappedContainer.add(property, value);
        }

        public void add(URI property, Calendar value) throws UpdateException {
            this.wrappedContainer.add(property, value);
        }

        public void add(URI property, Date value) throws UpdateException {
            this.wrappedContainer.add(property, value);
        }

        public void add(URI property, int value) throws UpdateException {
            this.wrappedContainer.add(property, value);
        }

        public void add(URI property, long value) throws UpdateException {
            this.wrappedContainer.add(property, value);
        }

        public void add(URI property, Node value) throws UpdateException {
            this.wrappedContainer.add(property, value);
        }

        public void add(URI property, String value) throws UpdateException {
            this.wrappedContainer.add(property, value);
        }

        public void dispose() {
        }

        public Collection getAll(URI property) {
            return this.wrappedContainer.getAll(property);
        }

        public Boolean getBoolean(URI property) {
            return this.wrappedContainer.getBoolean(property);
        }

        public Calendar getCalendar(URI property) {
            return this.wrappedContainer.getCalendar(property);
        }

        public Date getDate(URI property) {
            return this.wrappedContainer.getDate(property);
        }

        public URI getDescribedUri() {
            return this.wrappedContainer.getDescribedUri();
        }

        public Integer getInteger(URI property) {
            return this.wrappedContainer.getInteger(property);
        }

        public Long getLong(URI property) {
            return this.wrappedContainer.getLong(property);
        }

        public Model getModel() {
            return this.wrappedContainer.getModel();
        }

        public Node getNode(URI property) {
            return this.wrappedContainer.getNode(property);
        }

        public String getString(URI property) {
            return this.wrappedContainer.getString(property);
        }

        public URI getURI(URI property) {
            return this.wrappedContainer.getURI(property);
        }

        public ValueFactory getValueFactory() {
            return this.wrappedContainer.getValueFactory();
        }

        public void put(URI property, boolean value) throws UpdateException {
            this.wrappedContainer.put(property, value);
        }

        public void put(URI property, Calendar value) throws UpdateException {
            this.wrappedContainer.put(property, value);
        }

        public void put(URI property, Date value) throws UpdateException {
            this.wrappedContainer.put(property, value);
        }

        public void put(URI property, int value) throws UpdateException {
            this.wrappedContainer.put(property, value);
        }

        public void put(URI property, long value) throws UpdateException {
            this.wrappedContainer.put(property, value);
        }

        public void put(URI property, Node value) throws UpdateException {
            this.wrappedContainer.put(property, value);
        }

        public void put(URI property, String value) throws UpdateException {
            this.wrappedContainer.put(property, value);
        }

        public void remove(Statement statement) throws UpdateException {
            this.wrappedContainer.remove(statement);
        }

        public void remove(URI property) throws UpdateException {
            this.wrappedContainer.remove(property);
        }
    }

    private static class FilteringRDFContainerFactory
    implements RDFContainerFactory {
        private RDFContainerFactory wrappedFactory;
        private RDFContainer filterContainer;
        private URI messageUri;

        FilteringRDFContainerFactory(RDFContainerFactory factory, RDFContainer filterContainer, URI uri) {
            this.wrappedFactory = factory;
            this.filterContainer = new UndisposableRDFContainer(filterContainer);
            this.messageUri = uri;
        }

        public RDFContainer getRDFContainer(URI uri) {
            if (uri.equals(this.messageUri)) {
                return this.filterContainer;
            }
            return this.wrappedFactory.getRDFContainer(uri);
        }
    }
}

