/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.mbox;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.crawler.mail.DataObjectFactory;
import org.semanticdesktop.aperture.crawler.mail.MailUtil;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerException;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerHandler;
import org.semanticdesktop.aperture.subcrawler.base.AbstractSubCrawler;
import org.semanticdesktop.aperture.subcrawler.mbox.FromLineFilterStream;
import org.semanticdesktop.aperture.subcrawler.mbox.MboxSubCrawlerFactory;
import org.semanticdesktop.aperture.vocabulary.NIE;

public class MboxSubCrawler
extends AbstractSubCrawler {
    private boolean stopRequested;

    public void subCrawl(URI id, InputStream stream, SubCrawlerHandler handler, DataSource dataSource, AccessData accessData, Charset charset, String mimeType, RDFContainer parentMetadata) throws SubCrawlerException {
        DataObjectFactory fac = null;
        FromLineFilterStream fromLineFilterStream = new FromLineFilterStream(stream);
        this.stopRequested = false;
        while (!this.stopRequested) {
            try {
                byte[] bytes = fromLineFilterStream.getNextMessageBytes();
                if (bytes == null) {
                    return;
                }
                MimeMessage message = new MimeMessage(null, new ByteArrayInputStream(bytes));
                URI attachmentUriPrefix = this.createChildUri(parentMetadata.getDescribedUri(), MailUtil.getMessageId(message));
                RDFContainerFactory myFac = handler.getRDFContainerFactory(parentMetadata.getDescribedUri().toString());
                fac = new DataObjectFactory(message, myFac, null, dataSource, attachmentUriPrefix, null, "/", attachmentUriPrefix.toString());
                DataObject object = null;
                boolean first = true;
                while (!this.stopRequested && (object = fac.getObject()) != null) {
                    String queuedUri = object.getID().toString();
                    if (first) {
                        object.getMetadata().add(NIE.isPartOf, parentMetadata.getDescribedUri());
                        first = false;
                    }
                    if (accessData != null && accessData.get(queuedUri, "accessed") != null) {
                        object.dispose();
                        if (accessData.isTouched(queuedUri)) continue;
                        accessData.touch(queuedUri);
                        handler.objectNotModified(queuedUri);
                        continue;
                    }
                    if (accessData != null) {
                        accessData.put(queuedUri, "accessed", "");
                        accessData.touch(queuedUri);
                    }
                    MailUtil.registerParentRelationshipInAccessData(object, accessData);
                    handler.objectNew(object);
                }
            }
            catch (MessagingException e) {
                throw new SubCrawlerException(e);
            }
            catch (IOException e) {
                throw new SubCrawlerException(e);
            }
            finally {
                if (fac == null) continue;
                fac.disposeRemainingObjects();
            }
        }
    }

    public void stopSubCrawler() {
        this.stopRequested = true;
    }

    public String getUriPrefix() {
        return MboxSubCrawlerFactory.MBOX_URI_PREFIX;
    }
}

