/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.mbox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FromLineFilterStream {
    private static final byte[] FROM_LINE = new byte[]{70, 114, 111, 109, 32};
    private static final byte CARRIAGE_RETURN = 10;
    private InputStream in;
    private State state;
    private byte[] lastFiveBytes;
    private byte sixthByte;
    private byte[] buffer;
    private int bufferSize;
    private int bufferPointer;
    private ByteArrayOutputStream out;

    public FromLineFilterStream(InputStream in) {
        this.in = in;
    }

    public byte[] getNextMessageBytes() throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
            this.lastFiveBytes = new byte[5];
            this.bufferSize = this.in.read(this.buffer);
            this.bufferPointer = 0;
            this.state = State.BEFORE_FROM;
        }
        this.out = new ByteArrayOutputStream();
        while (true) {
            switch (this.state) {
                case END_OF_STREAM: {
                    return null;
                }
                case BEFORE_FROM: {
                    this.readByte();
                    if (!this.foundFrom()) break;
                    this.state = State.IN_FROM;
                    break;
                }
                case IN_FROM: {
                    this.readByte();
                    if (this.lastFiveBytes[4] != 10) break;
                    this.state = State.CONTENT;
                    this.readByte();
                    this.readByte();
                    this.readByte();
                    this.readByte();
                    this.readByte();
                    break;
                }
                case CONTENT: {
                    this.readByte();
                    if (this.foundFrom()) {
                        this.out.write(this.sixthByte);
                        this.state = State.IN_FROM;
                        byte[] res = this.out.toByteArray();
                        this.out = new ByteArrayOutputStream();
                        return res;
                    }
                    if (this.state == State.END_OF_STREAM) {
                        this.out.write(this.sixthByte);
                        this.out.write(this.lastFiveBytes[0]);
                        this.out.write(this.lastFiveBytes[1]);
                        this.out.write(this.lastFiveBytes[2]);
                        this.out.write(this.lastFiveBytes[3]);
                        byte[] res = this.out.toByteArray();
                        this.out = new ByteArrayOutputStream();
                        return res;
                    }
                    this.out.write(this.sixthByte);
                }
            }
        }
    }

    private boolean foundFrom() {
        return this.lastFiveBytes[0] == FROM_LINE[0] && this.lastFiveBytes[1] == FROM_LINE[1] && this.lastFiveBytes[2] == FROM_LINE[2] && this.lastFiveBytes[3] == FROM_LINE[3] && this.lastFiveBytes[4] == FROM_LINE[4];
    }

    private void readByte() throws IOException {
        if (this.state == State.END_OF_STREAM) {
            return;
        }
        this.sixthByte = this.lastFiveBytes[0];
        this.lastFiveBytes[0] = this.lastFiveBytes[1];
        this.lastFiveBytes[1] = this.lastFiveBytes[2];
        this.lastFiveBytes[2] = this.lastFiveBytes[3];
        this.lastFiveBytes[3] = this.lastFiveBytes[4];
        if (this.bufferPointer < this.bufferSize) {
            this.lastFiveBytes[4] = this.buffer[this.bufferPointer];
            ++this.bufferPointer;
        } else {
            this.bufferSize = this.in.read(this.buffer);
            this.bufferPointer = 0;
            if (this.bufferSize == -1) {
                this.state = State.END_OF_STREAM;
                return;
            }
            this.lastFiveBytes[4] = this.buffer[this.bufferPointer];
            ++this.bufferPointer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        BEFORE_FROM,
        IN_FROM,
        CONTENT,
        END_OF_STREAM;

    }
}

