/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerFactory;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerRegistry;

public class SubCrawlerRegistryImpl
implements SubCrawlerRegistry {
    private HashMap subCrawlerFactories = new HashMap();
    private HashMap uriPrefixFactories = new HashMap();

    public void add(SubCrawlerFactory factory) {
        Set<SubCrawlerFactory> factorySet;
        if (factory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String mimeType : factory.getSupportedMimeTypes()) {
            factorySet = (Set)this.subCrawlerFactories.get(mimeType);
            if (factorySet == null) {
                factorySet = new HashSet();
                this.subCrawlerFactories.put(mimeType, factorySet);
            }
            factorySet.add(factory);
        }
        String prefix = factory.getUriPrefix();
        factorySet = (HashSet<SubCrawlerFactory>)this.uriPrefixFactories.get(prefix);
        if (factorySet == null) {
            factorySet = new HashSet<SubCrawlerFactory>();
            this.uriPrefixFactories.put(prefix, factorySet);
        }
        factorySet.add(factory);
    }

    public void remove(SubCrawlerFactory factory) {
        Set factorySet;
        for (String mimeType : factory.getSupportedMimeTypes()) {
            factorySet = (Set)this.subCrawlerFactories.get(mimeType);
            if (factorySet == null) continue;
            factorySet.remove(factory);
            if (!factorySet.isEmpty()) continue;
            this.subCrawlerFactories.remove(mimeType);
        }
        String prefix = factory.getUriPrefix();
        factorySet = (Set)this.uriPrefixFactories.get(prefix);
        if (factorySet != null) {
            factorySet.remove(factory);
            if (factorySet.isEmpty()) {
                this.uriPrefixFactories.remove(prefix);
            }
        }
    }

    public Set get(String mimeType) {
        Set factorySet = (Set)this.subCrawlerFactories.get(mimeType);
        if (factorySet == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(factorySet);
    }

    public Set getByPrefix(String prefix) {
        Set factorySet = (Set)this.uriPrefixFactories.get(prefix);
        if (factorySet == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(factorySet);
    }

    public Set getAll() {
        HashSet result = new HashSet();
        for (Set factorySet : this.subCrawlerFactories.values()) {
            result.addAll(factorySet);
        }
        return result;
    }
}

