/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.subcrawler.base.AbstractCompressorSubCrawler;

public class BZip2SubCrawler
extends AbstractCompressorSubCrawler {
    protected InputStream getUncompressedStream(InputStream stream) throws IOException {
        return new BZip2CompressorInputStream(stream);
    }

    public String getUriPrefix() {
        return "bzip2";
    }

    protected URI getContentUri(URI archiveUri) {
        String name = ModelUtil.getFileName(archiveUri);
        if (name.endsWith(".bz2")) {
            return this.createChildUri(archiveUri, name.substring(0, name.length() - 4));
        }
        if (name.endsWith(".tbz")) {
            return this.createChildUri(archiveUri, name.substring(0, name.length() - 3) + "tar");
        }
        if (name.endsWith(".tbz2")) {
            return this.createChildUri(archiveUri, name.substring(0, name.length() - 4) + "tar");
        }
        return super.getContentUri(archiveUri);
    }
}

