/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.base;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.subcrawler.SubCrawler;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerException;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerHandler;
import org.semanticdesktop.aperture.util.StreamMonitor;

public class ThreadedSubCrawlerWrapper {
    public static final long DEFAULT_MAX_PROCESSING_TIME_PER_MB = 10000L;
    public static final long DEFAULT_MINIMUM_MAX_PROCESSING_TIME = 30000L;
    public static final long DEFAULT_MAX_IDLE_READ_TIME = 30000L;
    private SubCrawler subCrawler;
    private boolean stopRequested;
    private long maxProcessingTimePerMb = 10000L;
    private long minimumMaxProcessingTime = 30000L;
    private long maxIdleReadTime = 30000L;

    public ThreadedSubCrawlerWrapper(SubCrawler subcrawler) {
        this.subCrawler = subcrawler;
        this.stopRequested = false;
    }

    public ThreadedSubCrawlerWrapper(SubCrawler subCrawler, long maxProcessingTimePerMb, long minimumMaxProcessingTime, long maxIdleReadTime) {
        this.subCrawler = subCrawler;
        this.stopRequested = false;
        this.maxProcessingTimePerMb = maxProcessingTimePerMb;
        this.minimumMaxProcessingTime = minimumMaxProcessingTime;
        this.maxIdleReadTime = maxIdleReadTime;
    }

    public void stop() {
        this.stopRequested = true;
    }

    public void subCrawl(final URI id, InputStream input, final SubCrawlerHandler handler, final DataSource dataSource, final AccessData accessData, final Charset charset, final String mimeType, final RDFContainer parentMetadata) throws SubCrawlerException {
        StreamMonitor monitor = new StreamMonitor(input, new StreamMonitor.StreamConsumerFactory(){

            public StreamMonitor.StreamConsumer getConsumer(InputStream stream, StreamMonitor stMonitor) {
                return new SubCrawlingThread(id, stream, handler, dataSource, accessData, charset, mimeType, parentMetadata, stMonitor);
            }
        }, new StreamMonitor.StopRequestor(){

            public boolean isStopRequested() {
                return ThreadedSubCrawlerWrapper.this.stopRequested;
            }
        }, this.maxProcessingTimePerMb, this.minimumMaxProcessingTime, this.maxIdleReadTime);
        try {
            monitor.start();
        }
        catch (Exception e) {
            if (e instanceof SubCrawlerException) {
                throw (SubCrawlerException)e;
            }
            if (e instanceof StreamMonitor.ProcessingAbortedException) {
                throw new SubCrawlingAbortedException();
            }
            if (e instanceof StreamMonitor.ProcessingInterruptedException) {
                throw new SubCrawlingInterruptedException();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SubCrawlerException(e);
        }
    }

    private static class SubCrawlerHandlerWrapper
    implements SubCrawlerHandler {
        private SubCrawlerHandler wrappedHandler;
        private StreamMonitor monitor;

        public SubCrawlerHandlerWrapper(SubCrawlerHandler wrappedHandler, StreamMonitor monitor) {
            this.wrappedHandler = wrappedHandler;
            this.monitor = monitor;
        }

        public RDFContainerFactory getRDFContainerFactory(String url) {
            return this.wrappedHandler.getRDFContainerFactory(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectChanged(DataObject object) {
            try {
                this.monitor.suspendMonitoring();
                this.wrappedHandler.objectChanged(object);
            }
            finally {
                this.monitor.resumeMonitoring();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectNew(DataObject object) {
            try {
                this.monitor.suspendMonitoring();
                this.wrappedHandler.objectNew(object);
            }
            finally {
                this.monitor.resumeMonitoring();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectNotModified(String url) {
            try {
                this.monitor.suspendMonitoring();
                this.wrappedHandler.objectNotModified(url);
            }
            finally {
                this.monitor.resumeMonitoring();
            }
        }
    }

    private class SubCrawlingThread
    extends StreamMonitor.StreamConsumer {
        private URI id;
        private InputStream input;
        private Charset charset;
        private String mimeType;
        private RDFContainer parentMetadata;
        private SubCrawlerHandler handler;
        private DataSource dataSource;
        private AccessData accessData;
        private Exception exception;
        private StreamMonitor monitor;

        public SubCrawlingThread(URI id, InputStream stream, SubCrawlerHandler handler, DataSource dataSource, AccessData accessData, Charset charset, String mimeType, RDFContainer parentMetadata, StreamMonitor monitor) {
            this.id = id;
            this.input = stream;
            this.handler = handler;
            this.dataSource = dataSource;
            this.accessData = accessData;
            this.charset = charset;
            this.mimeType = mimeType;
            this.parentMetadata = parentMetadata;
            this.handler = handler;
            this.monitor = monitor;
        }

        public void run() {
            try {
                ThreadedSubCrawlerWrapper.this.subCrawler.subCrawl(this.id, this.input, new SubCrawlerHandlerWrapper(this.handler, this.monitor), this.dataSource, this.accessData, this.charset, this.mimeType, this.parentMetadata);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public void abortProcessing() {
            this.interrupt();
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class SubCrawlingInterruptedException
    extends SubCrawlerException {
        private static final long serialVersionUID = 21381236871185564L;

        public SubCrawlingInterruptedException() {
            super("Subcrawling has been interrupted by the user");
        }
    }

    public static class SubCrawlingAbortedException
    extends SubCrawlerException {
        private static final long serialVersionUID = -1806199350296089459L;

        public SubCrawlingAbortedException() {
            super("Subcrawling has been aborted due to problems with the SubCrawler");
        }
    }
}

