/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.FileDataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;
import org.semanticdesktop.aperture.subcrawler.PathNotFoundException;
import org.semanticdesktop.aperture.subcrawler.SubCrawler;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerException;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerFactory;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerHandler;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerRegistry;
import org.semanticdesktop.aperture.util.HttpClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubCrawlerUtil {
    private static final Pattern uriSchemePattern = Pattern.compile("\\w\\w+:");
    private static Logger logger = LoggerFactory.getLogger(SubCrawlerUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataObject getDataObject(URI uri, InputStream stream, DataSource dataSource, Charset charset, String mimeType, RDFContainerFactory containerFactory, SubCrawlerRegistry registry) throws SubCrawlerException, PathNotFoundException, IOException {
        if (!SubCrawlerUtil.isSubcrawledObjectUri(uri)) {
            throw new SubCrawlerException("not a proper subcrawled object uri: " + uri.toString());
        }
        LinkedList<String[]> stack = new LinkedList<String[]>();
        URI currentUri = new URIImpl(uri.toString());
        while (SubCrawlerUtil.isSubcrawledObjectUri(currentUri)) {
            String[] current = new String[3];
            current[0] = SubCrawlerUtil.getSubCrawlerPrefix(currentUri);
            current[1] = SubCrawlerUtil.getSubCrawledObjectPath(currentUri);
            if ((currentUri = SubCrawlerUtil.getParentObjectUri(currentUri)) != null) {
                current[2] = currentUri.toString();
            }
            stack.add(0, current);
        }
        boolean bad = false;
        DataObject object = null;
        InputStream currentStream = stream;
        try {
            while (!stack.isEmpty()) {
                String[] current = (String[])stack.remove(0);
                Set set = registry.getByPrefix(current[0]);
                if (set.isEmpty()) {
                    bad = true;
                    throw new SubCrawlerException("Couldn't find subcrawler for the prefix: " + current[0]);
                }
                SubCrawlerFactory factory = (SubCrawlerFactory)set.iterator().next();
                SubCrawler subCrawler = factory.get();
                bad = true;
                DataObject newObject = subCrawler.getDataObject(new URIImpl(current[2]), current[1], currentStream, dataSource, charset, mimeType, containerFactory);
                if (!stack.isEmpty()) {
                    if (newObject instanceof FileDataObject) {
                        currentStream = ((FileDataObject)newObject).getContent();
                    } else {
                        throw new SubCrawlerException("an intermediate DataObject has no stream: " + currentUri);
                    }
                }
                ((DataObjectBase)newObject).setWrappedDataObject(object);
                object = newObject;
                bad = false;
            }
        }
        finally {
            if (bad && object != null) {
                object.dispose();
            }
        }
        return object;
    }

    public static URI getRootObjectUri(URI subCrawledObjectUri) {
        String string = subCrawledObjectUri.toString();
        int startIndex = 0;
        int endIndex = string.length();
        Matcher matcher = uriSchemePattern.matcher(string);
        int matchStart = -1;
        while (matcher.find()) {
            matchStart = matcher.start();
        }
        if (matchStart > 0) {
            startIndex = matchStart;
        }
        if ((endIndex = string.indexOf("!")) < 0) {
            endIndex = string.length();
        }
        return new URIImpl(string.substring(startIndex, endIndex));
    }

    public static URI getParentObjectUri(URI subCrawledObjectUri) {
        String string = subCrawledObjectUri.toString();
        int startIndex = 0;
        int endIndex = string.length();
        Matcher matcher = uriSchemePattern.matcher(string);
        if (matcher.find() && matcher.find()) {
            startIndex = matcher.start();
        }
        if ((endIndex = string.lastIndexOf("!")) > 0 && startIndex > 0) {
            return new URIImpl(string.substring(startIndex, endIndex));
        }
        return null;
    }

    public static String getSubCrawlerPrefix(URI subCrawledObjectUri) {
        String string = subCrawledObjectUri.toString();
        int startIndex = 0;
        int endIndex = string.length();
        Matcher matcher = uriSchemePattern.matcher(string);
        if (matcher.find() && matcher.find()) {
            startIndex = matcher.start();
        }
        if ((endIndex = string.lastIndexOf("!")) > 0 && startIndex > 0) {
            return string.substring(0, startIndex - 1);
        }
        return null;
    }

    public static String getSubCrawledObjectPath(URI subCrawledObjectUri) {
        String string = subCrawledObjectUri.toString();
        int startIndex = 0;
        int endIndex = string.length();
        Matcher matcher = uriSchemePattern.matcher(string);
        if (matcher.find() && matcher.find()) {
            startIndex = matcher.start();
        }
        if ((endIndex = string.lastIndexOf("!")) > 0 && startIndex > 0) {
            return HttpClientUtil.formUrlDecode(string.substring(endIndex + 1));
        }
        return null;
    }

    public static boolean isSubcrawledObjectUri(URI subCrawledObjectUri) {
        String string = subCrawledObjectUri.toString();
        int prefixesCount = 0;
        int exclamationsCount = 0;
        Matcher matcher = uriSchemePattern.matcher(string);
        while (matcher.find()) {
            ++prefixesCount;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '!') continue;
            ++exclamationsCount;
        }
        return prefixesCount > 1 && prefixesCount - 1 == exclamationsCount;
    }

    public static URI createChildUri(URI objectUri, String childPath, String prefix) {
        return new URIImpl(prefix + ":" + objectUri.toString() + "!/" + HttpClientUtil.formUrlEncode(childPath, "/-_."));
    }

    public static DataObject getDataObject(URI parentUri, String path, InputStream stream, DataSource dataSource, Charset charset, String mimeType, RDFContainerFactory factory, String prefix, SubCrawler sc) throws SubCrawlerException, PathNotFoundException {
        Model model = RDF2Go.getModelFactory().createModel();
        model.open();
        RDFContainerImpl parentMetadata = new RDFContainerImpl(model, parentUri);
        URI childUri = SubCrawlerUtil.createChildUri(parentUri, path.startsWith("/") ? path.substring(1) : path, prefix);
        GetDataObjectSubCrawlerHandler handler = new GetDataObjectSubCrawlerHandler(factory, childUri, sc);
        sc.subCrawl(parentUri, stream, handler, dataSource, null, charset, mimeType, parentMetadata);
        parentMetadata.dispose();
        DataObject result = handler.getObjectToReturn();
        if (result != null) {
            return result;
        }
        throw new PathNotFoundException(sc.getClass().getName(), parentUri, path);
    }

    private static class GetDataObjectSubCrawlerHandler
    implements SubCrawlerHandler {
        private RDFContainerFactory fac;
        private URI requiredUri;
        private SubCrawler sc;
        private DataObject objectToReturn;

        public GetDataObjectSubCrawlerHandler(RDFContainerFactory fac, URI requiredUri, SubCrawler sc) {
            this.fac = fac;
            this.requiredUri = requiredUri;
            this.sc = sc;
            this.objectToReturn = null;
        }

        public DataObject getObjectToReturn() {
            return this.objectToReturn;
        }

        public RDFContainerFactory getRDFContainerFactory(String url) {
            return this.fac;
        }

        public void objectNew(DataObject object) {
            if (object.getID().equals(this.requiredUri) && this.objectToReturn == null) {
                this.objectToReturn = object;
                this.sc.stopSubCrawler();
            } else {
                object.dispose();
            }
        }

        public void objectChanged(DataObject object) {
            logger.warn("Got an \"objectChanged\" call inside a getDataObject method, uri:" + object.getID());
            object.dispose();
        }

        public void objectNotModified(String url) {
            logger.warn("Got an \"objectNotModified\" call inside a getDataObject method, uri:" + url);
        }
    }
}

