/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustmanager.standard;

import java.io.File;
import javax.net.ssl.TrustManager;
import org.semanticdesktop.aperture.security.trustdecider.TrustDecider;
import org.semanticdesktop.aperture.security.trustmanager.TrustManagerFactory;
import org.semanticdesktop.aperture.security.trustmanager.standard.StandardTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTrustManagerFactory
implements TrustManagerFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private StandardTrustManager trustManager;
    private volatile TrustDecider trustDecider;
    private File persistentStorageFile;
    private volatile char[] persistentStoragePassword;

    public void setTrustDecider(TrustDecider trustDecider) {
        this.trustDecider = trustDecider;
    }

    public TrustDecider getTrustDecider() {
        return this.trustDecider;
    }

    public synchronized void setPersistentStorageFile(File file) {
        if (file != this.persistentStorageFile || file != null && !file.equals(this.persistentStorageFile)) {
            this.persistentStorageFile = file;
            this.trustManager = null;
        }
    }

    public synchronized File getPersistentStorageFile() {
        return this.persistentStorageFile;
    }

    public void setPersistentStoragePassword(char[] password) {
        this.persistentStoragePassword = password;
    }

    public synchronized TrustManager get() {
        if (this.trustManager == null) {
            try {
                this.trustManager = new StandardTrustManager(this.persistentStorageFile, this.persistentStoragePassword);
                this.trustManager.setTrustDecider(this.trustDecider);
            }
            catch (Exception e) {
                this.logger.error("Exception while creating trust manager", e);
            }
        }
        return this.trustManager;
    }
}

