/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustmanager.standard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.semanticdesktop.aperture.security.trustmanager.standard.CertificateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootCertificateStore
implements CertificateStore {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String fileName;
    private KeyStore keyStore;

    public RootCertificateStore(String fileName) {
        this.fileName = fileName;
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
                    File certFile;
                    if (RootCertificateStore.this.keyStore == null) {
                        RootCertificateStore.this.keyStore = KeyStore.getInstance("JKS");
                        RootCertificateStore.this.keyStore.load(null, null);
                    }
                    if ((certFile = new File(RootCertificateStore.this.fileName)).exists()) {
                        FileInputStream stream = new FileInputStream(certFile);
                        BufferedInputStream buffer = new BufferedInputStream(stream);
                        RootCertificateStore.this.keyStore.load(buffer, null);
                        buffer.close();
                        stream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            this.logger.error("Unrecognized nested exception, ignoring", e);
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
    }

    public void add(Certificate certificate) throws KeyStoreException {
    }

    public void remove(Certificate certificate) throws KeyStoreException {
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        return false;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate rootCertificate = this.keyStore.getCertificate(alias);
            try {
                certificate.verify(rootCertificate.getPublicKey());
                return true;
            }
            catch (Exception e) {
            }
        }
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        HashSet<Certificate> set = new HashSet<Certificate>();
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            set.add(this.keyStore.getCertificate(alias));
        }
        return set.iterator();
    }
}

