/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustdecider.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.semanticdesktop.aperture.security.trustdecider.Decision;
import org.semanticdesktop.aperture.security.trustdecider.TrustDecider;
import org.semanticdesktop.aperture.security.trustdecider.dialog.CertificateDialog;
import org.semanticdesktop.aperture.util.ResourceUtil;

public class TrustDeciderDialog
implements TrustDecider {
    private static final String RESOURCE_PACKAGE = "org/semanticdesktop/aperture/security/trustdecider/dialog/";
    private static final String WARNING_ICON_RESOURCE = "org/semanticdesktop/aperture/security/trustdecider/dialog/warning.png";
    private static final String CHECK_ICON_RESOURCE = "org/semanticdesktop/aperture/security/trustdecider/dialog/check.png";
    private Component parent;

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public Component getParent() {
        return this.parent;
    }

    public Decision decide(final X509Certificate[] chain, boolean rootCANotValid, boolean timeNotValid) {
        int result = -1;
        int last = chain.length - 1;
        if (chain[0] instanceof X509Certificate && chain[last] instanceof X509Certificate) {
            JLabel label;
            X509Certificate cert = chain[0];
            X509Certificate cert2 = chain[last];
            Principal prinSubject = cert.getSubjectDN();
            Principal prinIssuer = cert2.getIssuerDN();
            String subjectDNName = prinSubject.getName();
            String subjectName = null;
            int i = subjectDNName.indexOf("CN=");
            int j = 0;
            if (i < 0) {
                subjectName = "Unknown subject";
            } else {
                try {
                    j = subjectDNName.charAt(i += 3) == '\"' ? subjectDNName.indexOf(34, ++i) : subjectDNName.indexOf(44, i);
                    subjectName = j < 0 ? subjectDNName.substring(i) : subjectDNName.substring(i, j);
                }
                catch (Throwable e) {
                    subjectName = "Unknown subject";
                }
            }
            String issuerDNName = prinIssuer.getName();
            String issuerName = null;
            i = issuerDNName.indexOf("O=");
            j = 0;
            if (i < 0) {
                issuerName = "Unknown issuer";
            } else {
                try {
                    j = issuerDNName.charAt(i += 2) == '\"' ? issuerDNName.indexOf(34, ++i) : issuerDNName.indexOf(44, i);
                    issuerName = j < 0 ? issuerDNName.substring(i) : issuerDNName.substring(i, j);
                }
                catch (Throwable e) {
                    issuerName = "Unknown issuer";
                }
            }
            ArrayList<Object> dialogMsgArray = new ArrayList<Object>();
            dialogMsgArray.add("Do you want to accept the certificate from " + subjectName);
            dialogMsgArray.add("for the purpose of exchanging encrypted information?");
            dialogMsgArray.add(" ");
            dialogMsgArray.add("Publisher authenticity verified by: " + issuerName);
            dialogMsgArray.add(" ");
            if (rootCANotValid) {
                label = new JLabel("The security certificate was issued by a company that is not trusted.");
                label.setIcon(this.getImageIcon(WARNING_ICON_RESOURCE));
                dialogMsgArray.add(label);
            } else {
                label = new JLabel("The security certificate was issued by a company that is trusted.");
                label.setIcon(this.getImageIcon(CHECK_ICON_RESOURCE));
                dialogMsgArray.add(label);
            }
            if (timeNotValid) {
                label = new JLabel("The security certificate has expired or is not yet valid.");
                label.setIcon(this.getImageIcon(WARNING_ICON_RESOURCE));
                dialogMsgArray.add(label);
            } else {
                label = new JLabel("The security certificate has not expired and is still valid.");
                label.setIcon(this.getImageIcon(CHECK_ICON_RESOURCE));
                dialogMsgArray.add(label);
            }
            dialogMsgArray.add(" ");
            dialogMsgArray.add("<html><b>Caution:</b> " + subjectName + " asserts that this content is safe.");
            dialogMsgArray.add("You should only accept this content if you trust " + subjectName + " to make that assertion.");
            Object[] buttons = new JButton[]{new JButton("Accept for Session"), new JButton("Always Accept"), new JButton("Deny"), new JButton("View Certificate(s)")};
            final JButton viewCertButton = buttons[3];
            for (int index = 0; index < buttons.length; ++index) {
                buttons[index].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        Component c = (Component)ae.getSource();
                        JButton thisButton = (JButton)c;
                        if (thisButton == viewCertButton) {
                            CertificateDialog certificateDialog = new CertificateDialog(chain);
                            certificateDialog.show(TrustDeciderDialog.this.parent);
                        } else {
                            while (c != null) {
                                if (!((c = c.getParent()) instanceof JOptionPane)) continue;
                                ((JOptionPane)c).setValue(thisButton);
                                break;
                            }
                        }
                    }
                });
            }
            result = JOptionPane.showOptionDialog(this.parent, dialogMsgArray.toArray(), "Security Alert", -1, 2, null, buttons, buttons[2]);
        }
        if (result == 0) {
            return Decision.TRUST_THIS_SESSION;
        }
        if (result == 1) {
            return Decision.TRUST_ALWAYS;
        }
        if (result == 2) {
            return Decision.DISTRUST;
        }
        return null;
    }

    private ImageIcon getImageIcon(String resourceName) {
        ImageIcon result = null;
        URL resourceURL = ResourceUtil.getURL(resourceName, TrustDeciderDialog.class);
        if (resourceURL != null) {
            result = new ImageIcon(resourceURL);
        }
        return result;
    }
}

