/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.bundle;

import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.semanticdesktop.aperture.security.trustdecider.TrustDeciderFactory;
import org.semanticdesktop.aperture.security.trustdecider.TrustDeciderRegistry;
import org.semanticdesktop.aperture.security.trustdecider.impl.TrustDeciderRegistryImpl;
import org.semanticdesktop.aperture.security.trustmanager.TrustManagerFactory;
import org.semanticdesktop.aperture.security.trustmanager.TrustManagerRegistry;
import org.semanticdesktop.aperture.security.trustmanager.impl.TrustManagerRegistryImpl;

public class SecurityServiceActivator
implements BundleActivator {
    private BundleContext bc = null;
    private ServiceRegistration deciderRegistryRegistration;
    private TrustDeciderRegistry deciderRegistry;
    private ServiceRegistration managerRegistryRegistration;
    private TrustManagerRegistry managerRegistry;
    private DeciderListener deciderListener;
    private ManagerListener managerListener;

    public void start(BundleContext context) throws Exception {
        int i;
        this.bc = context;
        this.deciderRegistry = new TrustDeciderRegistryImpl();
        this.deciderRegistryRegistration = this.bc.registerService(TrustDeciderRegistry.class.getName(), (Object)this.deciderRegistry, new Hashtable());
        String filter = "(objectclass=" + TrustDeciderFactory.class.getName() + ")";
        this.deciderListener = new DeciderListener();
        this.bc.addServiceListener((ServiceListener)this.deciderListener, filter);
        ServiceReference[] references = this.bc.getServiceReferences(null, filter);
        for (i = 0; references != null && i < references.length; ++i) {
            this.deciderListener.serviceChanged(new ServiceEvent(1, references[i]));
        }
        this.managerRegistry = new TrustManagerRegistryImpl();
        this.managerRegistryRegistration = this.bc.registerService(TrustManagerRegistry.class.getName(), (Object)this.managerRegistry, new Hashtable());
        filter = "(objectclass=" + TrustManagerFactory.class.getName() + ")";
        this.managerListener = new ManagerListener();
        this.bc.addServiceListener((ServiceListener)this.managerListener, filter);
        references = this.bc.getServiceReferences(null, filter);
        for (i = 0; references != null && i < references.length; ++i) {
            this.managerListener.serviceChanged(new ServiceEvent(1, references[i]));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.bc.removeServiceListener((ServiceListener)this.deciderListener);
        this.bc.removeServiceListener((ServiceListener)this.managerListener);
        this.deciderRegistryRegistration.unregister();
        this.managerRegistryRegistration.unregister();
        this.bc = null;
    }

    private class DeciderListener
    implements ServiceListener {
        private DeciderListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (SecurityServiceActivator.this.bc == null) {
                return;
            }
            switch (event.getType()) {
                case 1: {
                    TrustDeciderFactory factory = (TrustDeciderFactory)SecurityServiceActivator.this.bc.getService(event.getServiceReference());
                    SecurityServiceActivator.this.deciderRegistry.add(factory);
                    break;
                }
                case 2: {
                    TrustDeciderFactory factory = (TrustDeciderFactory)SecurityServiceActivator.this.bc.getService(event.getServiceReference());
                    SecurityServiceActivator.this.deciderRegistry.remove(factory);
                    SecurityServiceActivator.this.deciderRegistry.add(factory);
                    break;
                }
                case 4: {
                    TrustDeciderFactory factory = (TrustDeciderFactory)SecurityServiceActivator.this.bc.getService(event.getServiceReference());
                    SecurityServiceActivator.this.deciderRegistry.remove(factory);
                }
            }
        }
    }

    private class ManagerListener
    implements ServiceListener {
        private ManagerListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (SecurityServiceActivator.this.bc == null) {
                return;
            }
            switch (event.getType()) {
                case 1: {
                    TrustManagerFactory factory = (TrustManagerFactory)SecurityServiceActivator.this.bc.getService(event.getServiceReference());
                    SecurityServiceActivator.this.managerRegistry.add(factory);
                    break;
                }
                case 2: {
                    TrustManagerFactory factory = (TrustManagerFactory)SecurityServiceActivator.this.bc.getService(event.getServiceReference());
                    SecurityServiceActivator.this.managerRegistry.remove(factory);
                    SecurityServiceActivator.this.managerRegistry.add(factory);
                    break;
                }
                case 4: {
                    TrustManagerFactory factory = (TrustManagerFactory)SecurityServiceActivator.this.bc.getService(event.getServiceReference());
                    SecurityServiceActivator.this.managerRegistry.remove(factory);
                }
            }
        }
    }
}

