/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.runtime;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.regex.Pattern;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataAccessorFactory;
import org.semanticdesktop.aperture.accessor.DataAccessorRegistry;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.FileDataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.RDFContainerFactoryImpl;
import org.semanticdesktop.aperture.accessor.impl.DefaultDataAccessorRegistry;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.ExtractorFactory;
import org.semanticdesktop.aperture.extractor.ExtractorRegistry;
import org.semanticdesktop.aperture.extractor.FileExtractor;
import org.semanticdesktop.aperture.extractor.FileExtractorFactory;
import org.semanticdesktop.aperture.extractor.impl.DefaultExtractorRegistry;
import org.semanticdesktop.aperture.mime.identifier.MimeTypeIdentifier;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicMimeTypeIdentifier;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerRegistry;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerUtil;
import org.semanticdesktop.aperture.subcrawler.impl.DefaultSubCrawlerRegistry;
import org.semanticdesktop.aperture.util.HttpClientUtil;
import org.semanticdesktop.aperture.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApertureRuntime {
    private static final Pattern URI_START_PATTERN = Pattern.compile("^[a-z]+:.*$");
    private Logger logger = LoggerFactory.getLogger(ApertureRuntime.class);
    private DataAccessorRegistry accessorRegistry;
    private SubCrawlerRegistry subCrawlerRegistry;
    private ExtractorRegistry extractorRegistry = new DefaultExtractorRegistry();
    private MimeTypeIdentifier identifier = new MagicMimeTypeIdentifier();

    public ApertureRuntime() {
        this.accessorRegistry = new DefaultDataAccessorRegistry();
        this.subCrawlerRegistry = new DefaultSubCrawlerRegistry();
    }

    public RDFContainer extractFrom(String uriString) throws IOException {
        if (uriString == null) {
            throw new NullPointerException("The URL cannot be null");
        }
        RDFContainerFactoryImpl fac = new RDFContainerFactoryImpl();
        URIImpl uri = new URIImpl(uriString);
        DataObject obj = null;
        if (SubCrawlerUtil.isSubcrawledObjectUri(uri)) {
            URI topLevelUri = SubCrawlerUtil.getRootObjectUri(uri);
            DataObject rootObj = null;
            try {
                rootObj = this.accessUri(topLevelUri, fac);
                if (rootObj == null) {
                    return null;
                }
                if (!(rootObj instanceof FileDataObject)) {
                    return null;
                }
                FileDataObject fobj = (FileDataObject)rootObj;
                InputStream contentStream = fobj.getContent();
                if (contentStream == null) {
                    return null;
                }
                obj = SubCrawlerUtil.getDataObject(uri, contentStream, null, null, null, new RDFContainerFactoryImpl(), this.subCrawlerRegistry);
            }
            catch (Exception e) {
                if (rootObj != null) {
                    rootObj.dispose();
                }
                return null;
            }
        } else {
            obj = this.accessUri(uri, fac);
        }
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof FileDataObject)) {
            RDFContainer containerToReturn = obj.getMetadata();
            this.safelyDispose(obj);
            return containerToReturn;
        }
        FileDataObject fobj = (FileDataObject)obj;
        InputStream stream = fobj.getContent();
        RDFContainer container = fobj.getMetadata();
        if (stream == null) {
            return container;
        }
        this.tryToApplyExtractors(stream, uri, container);
        this.safelyDispose(obj);
        return container;
    }

    private void safelyDispose(DataObject ob) {
        DataObjectBase obj = (DataObjectBase)ob;
        obj.setMetadata(new RDFContainerImpl(null, RDF.Bag, true));
        obj.dispose();
    }

    private void tryToApplyExtractors(InputStream stream, URI uri, RDFContainer container) throws IOException {
        boolean ok = false;
        try {
            String mimeType = this.identifyMimeType(stream, uri);
            ok = this.applyExtractor(uri, stream, mimeType, container);
            if (ok) {
                return;
            }
            ok = this.applyFileExtractor(uri, stream, mimeType, container);
            if (ok) {
                return;
            }
        }
        catch (Exception e) {
            this.logger.warn("Couldn't extract information from: " + uri.toString(), e);
        }
    }

    private DataObject accessUri(URI topLevelUri, RDFContainerFactory fac) throws UrlNotFoundException, IOException {
        int colonIndex = topLevelUri.toString().indexOf(":");
        if (colonIndex < 0) {
            throw new IllegalArgumentException("The URI " + topLevelUri + "doesn't contain a colon");
        }
        String scheme = topLevelUri.toString().substring(0, colonIndex);
        Set dafSet = this.accessorRegistry.get(scheme);
        if (dafSet == null || dafSet.isEmpty()) {
            return null;
        }
        DataAccessorFactory daf = (DataAccessorFactory)dafSet.iterator().next();
        if (daf == null) {
            return null;
        }
        DataAccessor da = daf.get();
        DataObject dob = da.getDataObject(topLevelUri.toString(), null, null, fac);
        return dob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDFContainer extractFrom(InputStream stream, String nameOrPathOrUrl) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream cannot be null");
        }
        if (nameOrPathOrUrl == null) {
            throw new NullPointerException("nameOrPathOrUrl cannot be null");
        }
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        URI uri = this.tryToConvertToUri(nameOrPathOrUrl);
        Model model = RDF2Go.getModelFactory().createModel();
        model.open();
        RDFContainerImpl container = new RDFContainerImpl(model, uri);
        boolean ok = false;
        try {
            String mimeType = this.identifyMimeType(stream, uri);
            ok = this.applyExtractor(uri, stream, mimeType, container);
            if (ok) {
                RDFContainerImpl rDFContainerImpl = container;
                return rDFContainerImpl;
            }
            ok = this.applyFileExtractor(uri, stream, mimeType, (RDFContainer)container);
            if (ok) {
                RDFContainerImpl rDFContainerImpl = container;
                return rDFContainerImpl;
            }
        }
        catch (ExtractorException e) {
            this.logger.warn("Couldn't extract information from: " + uri.toString(), e);
        }
        finally {
            if (!ok) {
                container.dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDFContainer extractFrom(File file) throws IOException {
        String mimeType;
        BufferedInputStream stream;
        boolean ok;
        RDFContainerImpl container;
        URIImpl uri;
        block13: {
            if (file == null) {
                throw new NullPointerException("stream cannot be null");
            }
            if (!file.canRead()) {
                throw new IOException("The file: " + file.getAbsolutePath() + " is unreadable");
            }
            uri = new URIImpl(file.toURI().toString());
            Model model = RDF2Go.getModelFactory().createModel();
            model.open();
            container = new RDFContainerImpl(model, uri);
            ok = false;
            stream = null;
            stream = new BufferedInputStream(new FileInputStream(file));
            mimeType = this.identifyMimeType((InputStream)stream, uri);
            ok = this.applyExtractor(uri, stream, mimeType, container);
            if (!ok) break block13;
            RDFContainerImpl rDFContainerImpl = container;
            if (!ok) {
                container.dispose();
            }
            this.closeClosable(stream);
            return rDFContainerImpl;
        }
        try {
            ((InputStream)stream).close();
            ok = this.applyFileExtractor((URI)uri, file, mimeType, (RDFContainer)container);
            if (ok) {
                RDFContainerImpl rDFContainerImpl = container;
                if (!ok) {
                    container.dispose();
                }
                this.closeClosable(stream);
                return rDFContainerImpl;
            }
            if (!ok) {
                container.dispose();
            }
            this.closeClosable(stream);
        }
        catch (ExtractorException e) {
            try {
                this.logger.warn("Couldn't extract information from: " + ((Object)uri).toString(), e);
                if (!ok) {
                    container.dispose();
                }
                this.closeClosable(stream);
            }
            catch (Throwable throwable) {
                if (!ok) {
                    container.dispose();
                }
                this.closeClosable(stream);
                throw throwable;
            }
        }
        return null;
    }

    private void closeClosable(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    URI tryToConvertToUri(String nameOrPathOrUrl) {
        URIImpl uri = null;
        if (!URI_START_PATTERN.matcher(nameOrPathOrUrl = nameOrPathOrUrl.replaceAll("\\\\", "/")).matches()) {
            nameOrPathOrUrl = "file:" + nameOrPathOrUrl;
        }
        try {
            uri = new URIImpl(HttpClientUtil.formUrlEncode(nameOrPathOrUrl, "/:%!?&+.="));
        }
        catch (Exception e) {
            uri = new URIImpl("file:" + HttpClientUtil.formUrlEncode(nameOrPathOrUrl));
        }
        return uri;
    }

    public String identifyMimeType(InputStream stream, String nameOrPathOrUrl) throws IOException {
        URI uri = null;
        if (nameOrPathOrUrl != null) {
            uri = this.tryToConvertToUri(nameOrPathOrUrl);
        }
        return this.identifyMimeType(stream, uri);
    }

    private String identifyMimeType(InputStream stream, URI uri) throws IOException {
        byte[] bytes = null;
        if (stream != null) {
            int minimumArrayLength = this.identifier.getMinArrayLength();
            if (stream.markSupported()) {
                stream.mark(minimumArrayLength + 10);
            }
            bytes = IOUtil.readBytes(stream, minimumArrayLength);
            if (stream.markSupported()) {
                stream.reset();
            }
        }
        return this.identifier.identify(bytes, null, uri);
    }

    private boolean applyExtractor(URI id, InputStream contentStream, String mimeType, RDFContainer metadata) throws ExtractorException {
        Set extractors = this.extractorRegistry.getExtractorFactories(mimeType);
        if (!extractors.isEmpty()) {
            ExtractorFactory factory = (ExtractorFactory)extractors.iterator().next();
            Extractor extractor = factory.get();
            extractor.extract(id, contentStream, null, mimeType, metadata);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyFileExtractor(URI id, InputStream stream, String mimeType, RDFContainer metadata) throws ExtractorException, IOException {
        Set fileextractors = this.extractorRegistry.getFileExtractorFactories(mimeType);
        if (!fileextractors.isEmpty()) {
            FileExtractorFactory factory = (FileExtractorFactory)fileextractors.iterator().next();
            FileExtractor extractor = factory.get();
            File tempFile = null;
            try {
                tempFile = File.createTempFile("aperture", "tmp");
                IOUtil.writeStream(stream, tempFile);
                extractor.extract(id, tempFile, null, mimeType, metadata);
                boolean bl = true;
                return bl;
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
        return false;
    }

    private boolean applyFileExtractor(URI id, File file, String mimeType, RDFContainer metadata) throws ExtractorException, IOException {
        Set fileextractors = this.extractorRegistry.getFileExtractorFactories(mimeType);
        if (!fileextractors.isEmpty()) {
            FileExtractorFactory factory = (FileExtractorFactory)fileextractors.iterator().next();
            FileExtractor extractor = factory.get();
            extractor.extract(id, file, null, mimeType, metadata);
            return true;
        }
        return false;
    }

    public ExtractorRegistry getExtractorRegistry() {
        return this.extractorRegistry;
    }

    public MimeTypeIdentifier getMimeTypeIdentifier() {
        return this.identifier;
    }
}

