/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.rdf.util;

import info.aduna.xml.XMLUtil;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.semanticdesktop.aperture.rdf.util.XmlSafetyUtils;

class XmlSafeWriter
extends FilterWriter {
    protected XmlSafeWriter(Writer out) {
        super(out);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        char[] ncbuf = XmlSafetyUtils.makeXmlSafe(cbuf, off, len);
        if (ncbuf == cbuf) {
            super.write(cbuf, off, len);
        } else {
            super.write(ncbuf, 0, ncbuf.length);
        }
    }

    public void write(int c) throws IOException {
        if (XMLUtil.isValidCharacterDataChar((int)c)) {
            this.out.write(c);
        } else {
            this.out.write(32);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        String nstr = XmlSafetyUtils.makeXmlSafe(str, off, len);
        if (nstr == str) {
            super.write(str, off, len);
        } else {
            super.write(nstr, 0, nstr.length());
        }
    }
}

