/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.rdf.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.ListMap;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;
import org.semanticdesktop.aperture.vocabulary.FRESNEL;
import org.semanticdesktop.aperture.vocabulary.GEO;
import org.semanticdesktop.aperture.vocabulary.NAO;
import org.semanticdesktop.aperture.vocabulary.NCAL;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NEXIF;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NID3;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.vocabulary.NMO;
import org.semanticdesktop.aperture.vocabulary.SOURCEFORMAT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InferenceUtil {
    private final ListMap<URI, URI> superProperties = new ListMap();
    private final ListMap<URI, URI> superClasses = new ListMap();

    public void readOntology(Model model) {
        Statement s;
        ClosableIterator i = model.findStatements(Variable.ANY, RDFS.subPropertyOf, Variable.ANY);
        while (i.hasNext()) {
            s = (Statement)i.next();
            this.learnInferenceFor(s, this.superProperties);
        }
        i = model.findStatements(Variable.ANY, RDFS.subClassOf, Variable.ANY);
        while (i.hasNext()) {
            s = (Statement)i.next();
            this.learnInferenceFor(s, this.superClasses);
        }
    }

    public void extendContent(RDFContainer container) {
        this.extendContent(container.getModel());
    }

    public void extendContent(Model model) {
        LinkedList<Statement> toadd = new LinkedList<Statement>();
        Iterator i$ = model.iterator();
        while (i$.hasNext()) {
            List<URI> sclasses;
            Statement s = (Statement)i$.next();
            URI p = s.getPredicate();
            List<URI> sprops = this.superProperties.get(p);
            if (sprops != null) {
                for (URI sprop : sprops) {
                    toadd.add(model.createStatement(s.getSubject(), sprop, s.getObject()));
                }
            }
            if (!RDF.type.equals(s.getPredicate()) || !(s.getObject() instanceof URI) || (sclasses = this.superClasses.get((URI)s.getObject())) == null) continue;
            for (URI sclass : sclasses) {
                toadd.add(model.createStatement(s.getSubject(), RDF.type, sclass));
            }
        }
        model.addAll(toadd.iterator());
    }

    private void learnInferenceFor(Statement s, ListMap<URI, URI> list) {
        if (!(s.getSubject() instanceof URI)) {
            return;
        }
        if (!(s.getObject() instanceof URI)) {
            return;
        }
        URI sub = (URI)s.getSubject();
        URI obj = (URI)s.getObject();
        list.put(sub, obj);
        List<URI> sp = list.get(obj);
        if (sp != null) {
            for (URI u : sp) {
                list.put(sub, u);
            }
        }
        for (Map.Entry<URI, URI> entry : list.entrySet()) {
            List<URI> sp2;
            if (!entry.getValue().equals(sub) || (sp2 = list.get(sub)) == null) continue;
            for (URI u : sp2) {
                list.put(entry.getKey(), u);
            }
        }
    }

    public static InferenceUtil createForCoreOntologies() {
        Model m = RDF2Go.getModelFactory().createModel();
        m.open();
        DATASOURCE.getDATASOURCEOntology(m);
        FRESNEL.getFRESNELOntology(m);
        GEO.getGEOOntology(m);
        NAO.getNAOOntology(m);
        NCAL.getNCALOntology(m);
        NCO.getNCOOntology(m);
        NEXIF.getNEXIFOntology(m);
        NFO.getNFOOntology(m);
        NID3.getNID3Ontology(m);
        NIE.getNIEOntology(m);
        NMO.getNMOOntology(m);
        SOURCEFORMAT.getSOURCEFORMATOntology(m);
        InferenceUtil util = new InferenceUtil();
        util.readOntology(m);
        m.close();
        return util;
    }
}

