/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.outlook;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.semanticdesktop.aperture.opener.DataOpener;
import org.semanticdesktop.aperture.opener.DataOpenerFactory;
import org.semanticdesktop.aperture.outlook.OutlookCrawler;
import org.semanticdesktop.aperture.outlook.OutlookDataSource;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;

public class OutlookOpenerFactory
implements DataOpenerFactory {
    private static final Set SUPPORTED_SCHEMES = Collections.singleton("outlook");
    private OutlookCrawler crawler;

    public DataOpener get() {
        if (this.crawler == null) {
            this.crawler = this.prepareCrawler();
        }
        return this.crawler;
    }

    private OutlookCrawler prepareCrawler() {
        OutlookCrawler resultCrawler = new OutlookCrawler();
        OutlookDataSource source = new OutlookDataSource();
        Model dummyModel = RDF2Go.getModelFactory().createModel();
        dummyModel.open();
        RDFContainerImpl configuration = new RDFContainerImpl(dummyModel, "urn:" + UUID.randomUUID().toString());
        source.setConfiguration(configuration);
        resultCrawler.setDataSource(source);
        return resultCrawler;
    }

    public Set getSupportedSchemes() {
        return SUPPORTED_SCHEMES;
    }
}

