/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.outlook;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComFailException;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.config.ConfigurationUtil;
import org.semanticdesktop.aperture.datasource.config.DomainBoundaries;
import org.semanticdesktop.aperture.opener.DataOpener;
import org.semanticdesktop.aperture.outlook.OutlookAccessor;
import org.semanticdesktop.aperture.outlook.OutlookDataSource;
import org.semanticdesktop.aperture.outlook.OutlookResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookCrawler
extends CrawlerBase
implements DataOpener {
    public static final String OUTLOOKURIPREFIX = "outlook://";
    private static int crashed = 0;
    private static boolean registerVMExitCode;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String NS = "http://www.gnowsis.org/ont/msoutlook/0.1#";
    public static final String ITEMID_IDENTIFIERPREFIX = "outlookitemid:";
    private OutlookAccessor accessor;
    private DomainBoundaries boundaries;
    protected String calendarTimeZone = "http://www.w3.org/2002/12/cal/tzd/Europe/Vienna#tz";
    private boolean hasRedemption = false;
    Dispatch outlookApp;
    Dispatch outlookMapi;
    private HashMap params;
    private String uriPrefix;

    protected void beginCall() {
        if (this.source == null) {
            throw new RuntimeException("cannot prepare crawler, datasource not set");
        }
        try {
            ComThread.doCoInitialize((int)0);
        }
        catch (Throwable t) {
            this.logger.error("Cannot init Com", t);
        }
        try {
            ActiveXComponent x = new ActiveXComponent("Redemption.SafeContactItem");
            x.safeRelease();
            this.hasRedemption = true;
            this.logger.info("found Oulook-Redemption and will use it to access information.");
        }
        catch (ComFailException x) {
            this.logger.warn("You will be bugged by MS-Outlook messages. To avoid that, download and install redemption from http://www.dimastr.com/redemption/");
            this.hasRedemption = false;
        }
        this.outlookApp = new ActiveXComponent("Outlook.Application");
        this.outlookMapi = Dispatch.call((Dispatch)this.outlookApp, (String)"GetNamespace", (Object)"MAPI").toDispatch();
        this.accessor = new OutlookAccessor();
        OutlookCrawler.registerVMExitCode();
    }

    private static void registerVMExitCode() {
        if (!registerVMExitCode) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        ComThread.Release();
                        ComThread.quitMainSTA();
                        ComThread.doCoUninitialize();
                    }
                    catch (Throwable x) {
                        x.printStackTrace();
                    }
                }
            });
            registerVMExitCode = true;
        }
    }

    public void crashChecker(Throwable cause) {
        if (++crashed > 2) {
            crashed = 0;
        } else {
            this.logger.warn("Outlook crashed. This is the " + crashed + " time. Will restart ActiveX on 3rd fail. ", cause);
        }
    }

    private boolean crawlContainer(OutlookResource.Folder folder, OutlookResource parent) {
        this.logger.info("crawling folder: " + folder.getUri());
        this.crawlSingleResource(folder, parent);
        boolean result = this.crawlSubItems(folder);
        if (!result) {
            return false;
        }
        result = this.crawlSubFolders(folder);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExitCode crawlObjects() {
        this.beginCall();
        try {
            ExitCode exitCode;
            OutlookResource.RootFolder root = new OutlookResource.RootFolder(this);
            try {
                this.params = new HashMap(2);
                boolean crawlCompleted = this.crawlRoot(root);
                this.params = null;
                exitCode = crawlCompleted ? ExitCode.COMPLETED : ExitCode.STOP_REQUESTED;
            }
            catch (Throwable throwable) {
                root.release();
                throw throwable;
            }
            root.release();
            return exitCode;
        }
        finally {
            this.endCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean crawlRoot(OutlookResource.RootFolder folder) {
        this.crawlSingleResource(folder, null);
        Variant v = Dispatch.get((Dispatch)folder.getResource(), (String)"Folders");
        if (v == null) {
            return true;
        }
        Dispatch folders = v.toDispatch();
        try {
            int i;
            int count = Dispatch.get((Dispatch)folders, (String)"Count").toInt();
            if (count == 0) {
                boolean bl = true;
                return bl;
            }
            for (i = 1; !this.stopRequested && i <= count; ++i) {
                try {
                    Dispatch dFolder = Dispatch.invoke((Dispatch)folders, (String)"Item", (int)2, (Object[])new Object[]{new Integer(i)}, (int[])new int[1]).toDispatch();
                    OutlookResource.Folder subfolder = OutlookResource.createWrapperForFolder(this, dFolder);
                    try {
                        if (this.boundaries.inDomain(subfolder.getUri())) {
                            this.crawlContainer(subfolder, folder);
                            continue;
                        }
                        this.logger.info("not in domain, stepping over: " + subfolder.getUri());
                        continue;
                    }
                    finally {
                        subfolder.release();
                    }
                }
                catch (Exception ex) {
                    this.logger.warn("Error while adding subfolders of " + folder.getUri(), ex);
                }
            }
            if (i <= count) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            folders.safeRelease();
        }
        return true;
    }

    private void crawlSingleResource(OutlookResource resource, OutlookResource parent) {
        String uri = resource.getUri();
        this.logger.info("crawling resource " + uri);
        this.reportAccessingObject(uri);
        boolean knownObject = this.accessData == null ? false : this.accessData.isKnownId(uri);
        RDFContainerFactory containerFactory = this.getRDFContainerFactory(uri);
        try {
            DataObject dataObject = this.getAccessor().getDataObjectIfModifiedOutlook(uri, this.source, this.accessData, this.params, containerFactory, resource, parent);
            if (dataObject == null) {
                this.reportUnmodifiedDataObject(uri);
            } else if (knownObject) {
                this.reportModifiedDataObject(dataObject);
            } else {
                this.reportNewDataObject(dataObject);
            }
        }
        catch (UrlNotFoundException e) {
            this.logger.warn("unable to access " + uri, e);
        }
        catch (IOException e) {
            this.logger.warn("I/O error while processing " + uri, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean crawlSubFolders(OutlookResource.Folder folder) {
        Variant v = Dispatch.get((Dispatch)folder.getResource(), (String)"Folders");
        if (v == null) {
            return true;
        }
        Dispatch folders = v.toDispatch();
        ArrayList<OutlookResource.Folder> crawlLater = new ArrayList<OutlookResource.Folder>();
        try {
            int i;
            int count = Dispatch.get((Dispatch)folders, (String)"Count").toInt();
            if (count == 0) {
                boolean bl = true;
                return bl;
            }
            for (i = 1; !this.stopRequested && i <= count; ++i) {
                try {
                    Dispatch dFolder = Dispatch.invoke((Dispatch)folders, (String)"Item", (int)2, (Object[])new Object[]{new Integer(i)}, (int[])new int[1]).toDispatch();
                    OutlookResource.Folder subfolder = OutlookResource.createWrapperForFolder(this, dFolder);
                    int dtype = subfolder.getDefaultItemType();
                    boolean isEmail = false;
                    if (dtype == 0) {
                        isEmail = true;
                        String name = subfolder.getName();
                        if (name != null && ((name = name.toLowerCase()).contains("kontakte") || name.contains("Contacts"))) {
                            isEmail = false;
                        }
                    }
                    if (isEmail) {
                        crawlLater.add(subfolder);
                        continue;
                    }
                    try {
                        this.crawlContainer(subfolder, folder);
                        continue;
                    }
                    finally {
                        subfolder.release();
                    }
                }
                catch (Exception ex) {
                    this.logger.info("Error while adding subfolders of " + folder.getUri(), ex);
                }
            }
            Iterator folderI2 = crawlLater.iterator();
            while (!this.stopRequested && folderI2.hasNext()) {
                OutlookResource.Folder f = (OutlookResource.Folder)folderI2.next();
                folderI2.remove();
                try {
                    this.crawlContainer(f, folder);
                }
                catch (Exception ex) {
                    this.logger.info("Error while adding subfolders of " + folder.getUri(), ex);
                }
                finally {
                    f.release();
                }
            }
            if (crawlLater.isEmpty() && i <= count) {
                boolean folderI2 = false;
                return folderI2;
            }
        }
        finally {
            if (!crawlLater.isEmpty()) {
                for (OutlookResource.Folder f : crawlLater) {
                    try {
                        f.release();
                    }
                    catch (Exception x) {
                        this.logger.info("Error releasing " + f, x);
                    }
                }
            }
            folders.safeRelease();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean crawlSubItems(OutlookResource.Folder folder) {
        int i;
        Dispatch subj = folder.getResource();
        Dispatch items = Dispatch.get((Dispatch)subj, (String)"Items").toDispatch();
        if (items == null) {
            return true;
        }
        int count = Dispatch.get((Dispatch)items, (String)"Count").toInt();
        if (count == 0) {
            return true;
        }
        try {
        }
        catch (Exception ex) {
            this.logger.warn("Error while adding subfolders of " + folder.getUri(), ex);
            return true;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        for (i = 1; !this.stopRequested && i <= count; ++i) {
            OutlookResource item;
            Dispatch dItem = Dispatch.invoke((Dispatch)items, (String)"Item", (int)2, (Object[])new Object[]{new Integer(i)}, (int[])new int[1]).toDispatch();
            if (dItem == null || (item = OutlookResource.createWrapperFor(this, dItem, this.logger)) == null) continue;
            try {
                this.crawlSingleResource(item, folder);
                continue;
            }
            finally {
                item.release();
            }
        }
        if (i <= count) {
            boolean bl = false;
            items.safeRelease();
            return bl;
        }
        return true;
    }

    protected void endCall() {
        if (this.outlookMapi != null) {
            this.outlookMapi.safeRelease();
            this.outlookMapi = null;
        }
        if (this.outlookApp != null) {
            this.outlookApp.safeRelease();
            this.outlookApp = null;
        }
        this.accessor = null;
    }

    protected OutlookAccessor getAccessor() {
        if (this.accessor == null) {
            throw new RuntimeException("accessor is null, call to beginCall() missing.");
        }
        return this.accessor;
    }

    protected Dispatch getOutlookMapi() {
        if (this.outlookMapi == null) {
            throw new RuntimeException("outlook MAPI is null, call to beginCall() missing.");
        }
        return this.outlookMapi;
    }

    public String getUriPrefix() {
        return this.uriPrefix;
    }

    public boolean hasRedemption() {
        return this.hasRedemption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(URI uri) throws IOException {
        this.logger.info("Outlook: opening uri " + uri);
        this.beginCall();
        OutlookResource resource = null;
        try {
            resource = OutlookResource.createWrapperFor(this, uri.toString(), this.logger);
            if (resource == null) {
                throw new IOException("outlook: cannot found uri " + uri);
            }
            try {
                Dispatch.call((Dispatch)resource.getResource(), (String)"Display");
                try {
                    Dispatch.call((Dispatch)resource.getResource(), (String)"Activate");
                }
                catch (Exception e) {}
            }
            catch (Exception ex) {
                throw new IOException("outlook: unable to display uri: " + uri + " reason: " + ex);
            }
        }
        finally {
            if (resource != null) {
                resource.release();
            }
            this.endCall();
        }
    }

    public void release() {
        System.gc();
        try {
            if (this.outlookApp != null) {
                this.outlookApp.safeRelease();
                this.outlookApp = null;
            }
            if (this.outlookMapi != null) {
                this.outlookMapi.safeRelease();
                this.outlookMapi = null;
            }
        }
        catch (Exception x) {
            this.logger.warn("Stopping outlook/Activex: " + x, x);
        }
        ComThread.quitMainSTA();
    }

    public void killKillKill() {
        try {
            if (this.outlookApp != null) {
                this.outlookApp.safeRelease();
                this.outlookApp = null;
            }
            if (this.outlookMapi != null) {
                this.outlookMapi.safeRelease();
                this.outlookMapi = null;
            }
        }
        catch (Exception x) {
            this.logger.warn("Stopping outlook/Activex: " + x, x);
        }
        try {
            ComThread.Release();
            ComThread.quitMainSTA();
            ComThread.doCoUninitialize();
        }
        catch (Exception x) {
            this.logger.warn("Stopping outlook/Activex: " + x, x);
        }
    }

    public void setDataSource(DataSource source) {
        super.setDataSource(source);
        this.uriPrefix = ((OutlookDataSource)source).getRootUrl();
        if (this.uriPrefix == null) {
            this.uriPrefix = OUTLOOKURIPREFIX;
            this.logger.warn("Outlook adapter missing the rootUrl property. Using " + this.uriPrefix + " instead.");
        } else {
            this.logger.info("crawling outlook, uri prefix: " + this.uriPrefix);
        }
        this.boundaries = ConfigurationUtil.getDomainBoundaries(source.getConfiguration());
    }

    public static class OLConst {
        public static final int olAppointmentItem = 1;
        public static final int olFolderCalendar = 9;
        public static final int olFolderContacts = 10;
    }
}

