/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.outlook;

import java.io.IOException;
import java.util.Map;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FolderDataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.outlook.OutlookCrawler;
import org.semanticdesktop.aperture.outlook.OutlookDataSource;
import org.semanticdesktop.aperture.outlook.OutlookResource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookAccessor
implements DataAccessor {
    public static final String PARAM_OUTLOOKRESOURCE = "ol_resource";
    public static final String PARAM_OUTLOOKPARENT = "ol_parent";
    public static final String PARAM_MAPI = "ol_mapi";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public DataObject getDataObject(String url, DataSource source, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        OutlookResource res = null;
        OutlookResource parent = null;
        if (params != null) {
            res = (OutlookResource)params.get(PARAM_OUTLOOKRESOURCE);
            parent = (OutlookResource)params.get(PARAM_OUTLOOKPARENT);
        }
        return this.getDataObjectIfModifiedOutlook(url, source, null, params, containerFactory, res, parent);
    }

    public DataObject getDataObjectIfModified(String url, DataSource source, AccessData accessData, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        OutlookResource res = null;
        OutlookResource parent = null;
        if (params != null) {
            res = (OutlookResource)params.get(PARAM_OUTLOOKRESOURCE);
            parent = (OutlookResource)params.get(PARAM_OUTLOOKPARENT);
        }
        return this.getDataObjectIfModifiedOutlook(url, source, accessData, params, containerFactory, res, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getDataObjectIfModifiedOutlook(String url, DataSource source, AccessData accessData, Map params, RDFContainerFactory containerFactory, OutlookResource resource, OutlookResource parent) throws UrlNotFoundException, IOException {
        this.logger.info("get data of " + url);
        OutlookCrawler crawler = null;
        boolean crappyHack = false;
        try {
            if (resource == null) {
                crawler = new OutlookCrawler();
                if (source == null) {
                    source = this.createDummyDataSource(url);
                    crappyHack = true;
                }
                crawler.setDataSource(source);
                crawler.beginCall();
                resource = OutlookResource.createWrapperFor(crawler, url, this.logger);
                if (resource == null) {
                    throw new UrlNotFoundException(url, "cannot crawl " + url + ", not found in Outlook.");
                }
            }
            if (accessData != null) {
                long lastModified = resource.getLastModified();
                String value = accessData.get(url, "date");
                if (value != null) {
                    long registeredDate;
                    block17: {
                        registeredDate = Long.parseLong(value);
                        if (registeredDate != lastModified) break block17;
                        this.logger.info(url + " not modified - reg:" + registeredDate);
                        DataObject dataObject = null;
                        return dataObject;
                    }
                    try {
                        this.logger.info(url + " was modified - reg:" + registeredDate + " new:" + lastModified);
                    }
                    catch (NumberFormatException e) {
                        this.logger.warn("illegal long: " + value, e);
                    }
                }
                accessData.put(url, "date", String.valueOf(lastModified));
            }
            URI id = URIImpl.createURIWithoutChecking(url);
            RDFContainer metadata = containerFactory.getRDFContainer(id);
            metadata.add(RDF.type, resource.getType());
            if (parent != null) {
                URIImpl parentURI = new URIImpl(parent.getUri());
                metadata.add(NIE.isPartOf, parentURI);
                metadata.add(metadata.getModel().createStatement(parentURI, RDF.type, NIE.InformationElement));
            } else {
                metadata.add(NIE.rootElementOf, source.getID());
            }
            resource.addData(metadata);
            DataObjectBase result = null;
            result = resource.isFolder() ? new FolderDataObjectBase(id, source, metadata) : new DataObjectBase(id, source, metadata);
            DataObjectBase dataObjectBase = result;
            return dataObjectBase;
        }
        finally {
            if (crawler != null) {
                crawler.endCall();
                crawler.release();
                if (resource != null) {
                    resource.release();
                }
                if (crappyHack) {
                    source.getConfiguration().dispose();
                }
            }
        }
    }

    private DataSource createDummyDataSource(String url) {
        Model model = RDF2Go.getModelFactory().createModel();
        model.open();
        RDFContainerImpl container = new RDFContainerImpl(model, url);
        OutlookDataSource source = new OutlookDataSource();
        source.setConfiguration(container);
        return source;
    }
}

