/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.opener.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.semanticdesktop.aperture.opener.DataOpenerFactory;
import org.semanticdesktop.aperture.opener.DataOpenerRegistry;

public class DataOpenerRegistryImpl
implements DataOpenerRegistry {
    private HashMap factories = new HashMap();

    public void add(DataOpenerFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String scheme : factory.getSupportedSchemes()) {
            HashSet<DataOpenerFactory> factorySet = (HashSet<DataOpenerFactory>)this.factories.get(scheme);
            if (factorySet == null) {
                factorySet = new HashSet<DataOpenerFactory>();
                this.factories.put(scheme, factorySet);
            }
            factorySet.add(factory);
        }
    }

    public void remove(DataOpenerFactory factory) {
        for (String scheme : factory.getSupportedSchemes()) {
            Set factorySet = (Set)this.factories.get(scheme);
            if (factorySet == null) continue;
            factorySet.remove(factory);
            if (!factorySet.isEmpty()) continue;
            this.factories.remove(scheme);
        }
    }

    public Set get(String mimeType) {
        Set factorySet = (Set)this.factories.get(mimeType);
        if (factorySet == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(factorySet);
    }

    public Set getAll() {
        HashSet result = new HashSet();
        for (Set factorySet : this.factories.values()) {
            result.addAll(factorySet);
        }
        return result;
    }
}

