/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.opener.email;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.opener.DataOpener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailOpener
implements DataOpener {
    private static Logger logger = LoggerFactory.getLogger(EmailOpener.class);
    private static String MSGID = "msgid://";
    int port = 10802;
    String host = "localhost";

    public void open(URI uri) throws IOException {
        this.openThunderbirdEmail(uri);
    }

    private void openThunderbirdEmail(URI uri) throws IOException {
        String url = uri.toString();
        if (!(url.startsWith("imap://") || url.startsWith("msgid://") || url.startsWith("email://"))) {
            throw new IOException("Email URI is not valid.");
        }
        String correctURI = url;
        if (url.startsWith("email://")) {
            correctURI = url.replaceFirst("email://", "msgid://");
        }
        if (url.startsWith("imap://")) {
            throw new UnsupportedOperationException("Imap URI not implemented in Aperture EmailOpener");
        }
        this.openCommand(correctURI);
    }

    public void openCommand(String uri) throws IOException {
        try {
            Socket sock = null;
            sock = new Socket(this.host, this.port);
            OutputStream out = sock.getOutputStream();
            String message = "open " + uri + " \n";
            out.write(message.getBytes());
            sock.close();
        }
        catch (Exception e) {
            logger.warn("Could not open the email uri: " + uri + " " + e, e);
            throw new IOException("Error opening uri " + uri + ": " + e.toString());
        }
    }
}

