/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.mime.identifier.magic;

public class MagicNumber {
    private byte[] magicBytes;
    private int offset;
    private int minimumLength;

    public MagicNumber(byte[] magicBytes, int offset) {
        if (magicBytes == null) {
            throw new IllegalArgumentException("magicBytes should not be null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset should be >= 0");
        }
        this.magicBytes = magicBytes;
        this.offset = offset;
        this.minimumLength = magicBytes.length + offset;
    }

    public byte[] getMagicBytes() {
        return this.magicBytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public boolean matches(byte[] bytes, int skippedLeadingBytes) {
        if (bytes.length < this.minimumLength + skippedLeadingBytes) {
            return false;
        }
        int realOffset = this.offset + skippedLeadingBytes;
        for (int i = 0; i < this.magicBytes.length; ++i) {
            if (this.magicBytes[i] == bytes[i + realOffset]) continue;
            return false;
        }
        return true;
    }
}

