/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.hypertext.linkextractor.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticdesktop.aperture.hypertext.linkextractor.LinkExtractorFactory;
import org.semanticdesktop.aperture.hypertext.linkextractor.LinkExtractorRegistry;

public class LinkExtractorRegistryImpl
implements LinkExtractorRegistry {
    private HashMap factories = new HashMap();

    public void add(LinkExtractorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String mimeType : factory.getSupportedMimeTypes()) {
            HashSet<LinkExtractorFactory> set = (HashSet<LinkExtractorFactory>)this.factories.get(mimeType);
            if (set == null) {
                set = new HashSet<LinkExtractorFactory>();
                this.factories.put(mimeType, set);
            }
            set.add(factory);
        }
    }

    public void remove(LinkExtractorFactory factory) {
        for (String mimeType : factory.getSupportedMimeTypes()) {
            Set set = (Set)this.factories.get(mimeType);
            if (set == null) continue;
            set.remove(factory);
            if (!set.isEmpty()) continue;
            this.factories.remove(mimeType);
        }
    }

    public Set getAll() {
        HashSet result = new HashSet();
        Iterator sets = this.factories.values().iterator();
        while (sets.hasNext()) {
            result.addAll((Set)sets.next());
        }
        return result;
    }

    public Set get(String mimeType) {
        Set set = (Set)this.factories.get(mimeType);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(set);
    }
}

