/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.hypertext.linkextractor.html;

import java.io.IOException;
import java.io.InputStream;
import org.semanticdesktop.aperture.hypertext.linkextractor.html.TokenHandler;

public class Tokenizer {
    private static final int LESS_THEN = 60;
    private static final int GREATER_THEN = 62;
    private static final int EQUALS = 61;
    private static final int EXCLAMATION = 33;
    private static final int MINUS = 45;
    private static final int DOUBLE_QUOTE = 34;
    private static final int QUOTE = 39;
    private static final int SLASH = 47;
    private static final char[] DOCTYPE = new char[]{'D', 'O', 'C', 'T', 'Y', 'P', 'E'};
    private TokenHandler tokenHandler;

    public Tokenizer(TokenHandler tokenHandler) {
        this.tokenHandler = tokenHandler;
    }

    public void read(InputStream input) throws IOException {
        this.tokenHandler.startDocument();
        int b = input.read();
        while (b != -1) {
            if (b == 60) {
                b = this.readTag(input);
                continue;
            }
            b = this.readText(input, b);
        }
        this.tokenHandler.endDocument();
    }

    private int readTag(InputStream input) throws IOException {
        int b = input.read();
        b = b == 47 ? this.readEndTag(input) : (b == 33 ? this.readDocTypeOrComment(input) : this.readStartTag(input, b));
        return b;
    }

    private int readStartTag(InputStream input, int firstByte) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int b = firstByte;
        while (b != 62 && b != -1 && !Character.isWhitespace((char)b)) {
            buffer.append((char)b);
            b = input.read();
        }
        if (b == -1) {
            return -1;
        }
        this.tokenHandler.startOfStartTag(buffer.toString());
        b = this.readAttributes(input, b);
        this.tokenHandler.endOfStartTag();
        return b;
    }

    private int readEndTag(InputStream input) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int b = input.read();
        while (b != 62 && b != -1) {
            buffer.append((char)b);
            b = input.read();
        }
        if (b != -1) {
            this.tokenHandler.endTag(buffer.toString());
            b = input.read();
        }
        return b;
    }

    private int readDocTypeOrComment(InputStream input) throws IOException {
        StringBuffer buffer = new StringBuffer();
        boolean isDocType = true;
        int b = -1;
        for (int i = 0; i < DOCTYPE.length; ++i) {
            b = input.read();
            if (b != -1) {
                if (Character.toUpperCase((char)b) == DOCTYPE[i]) continue;
                isDocType = false;
                break;
            }
            isDocType = false;
            break;
        }
        if (isDocType) {
            b = input.read();
            StringBuilder nameBuffer = new StringBuilder();
            b = this.readWord(nameBuffer, input, b, false);
            StringBuilder sysIdBuffer = new StringBuilder();
            b = this.readWord(sysIdBuffer, input, b, false);
            StringBuilder fpiBuffer = new StringBuilder();
            b = this.readWord(fpiBuffer, input, b, false);
            StringBuilder uriBuffer = new StringBuilder();
            b = this.readWord(uriBuffer, input, b, false);
            this.tokenHandler.docType(nameBuffer.toString(), sysIdBuffer.toString(), fpiBuffer.toString(), uriBuffer.toString());
        } else {
            int firstB = b;
            b = firstB != 62 && firstB != -1 ? input.read() : -1;
            if (firstB == 45 && b == 45) {
                boolean minusRead = false;
                b = input.read();
                while (b != -1) {
                    if (b == 45) {
                        if (minusRead) {
                            b = input.read();
                            break;
                        }
                        minusRead = true;
                        b = input.read();
                        continue;
                    }
                    if (minusRead) {
                        buffer.append('-');
                        minusRead = false;
                    }
                    buffer.append((char)b);
                    b = input.read();
                }
                this.tokenHandler.comment(buffer.toString());
            } else {
                buffer.append('!');
                if (firstB != 62 && firstB != -1) {
                    buffer.append((char)firstB);
                }
                while (b != 62 && b != -1) {
                    buffer.append((char)b);
                    b = input.read();
                }
                this.tokenHandler.startOfStartTag(buffer.toString());
                this.tokenHandler.endOfStartTag();
            }
        }
        while (b != 62 && b != -1) {
            b = input.read();
        }
        if (b != -1) {
            b = input.read();
        }
        return b;
    }

    private int readAttributes(InputStream input, int firstByte) throws IOException {
        int b = firstByte;
        while (b != 62 && b != -1) {
            StringBuilder nameBuffer = new StringBuilder();
            b = this.readWord(nameBuffer, input, b, true);
            if (nameBuffer.length() != 0) {
                if ((b = this.skipWhitespace(input, b)) == 61) {
                    StringBuilder valueBuffer = new StringBuilder();
                    b = input.read();
                    b = this.readWord(valueBuffer, input, b, false);
                    this.tokenHandler.attribute(nameBuffer.toString(), valueBuffer.toString());
                    continue;
                }
                this.tokenHandler.attribute(nameBuffer.toString());
                continue;
            }
            if (b != 61) continue;
            this.tokenHandler.error("Illegal attribute name '=', skipping character");
            b = input.read();
        }
        if (b != -1) {
            b = input.read();
        }
        return b;
    }

    private int readText(InputStream input, int firstByte) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int b = firstByte;
        while (b != 60 && b != -1) {
            buffer.append((char)b);
            b = input.read();
        }
        this.tokenHandler.text(buffer.toString());
        return b;
    }

    private int skipWhitespace(InputStream input, int firstByte) throws IOException {
        int b = firstByte;
        while (b != -1 && Character.isWhitespace((char)b)) {
            b = input.read();
        }
        return b;
    }

    private int readWord(StringBuilder word, InputStream input, int firstByte, boolean stopOnEquals) throws IOException {
        int b = firstByte;
        if ((b = this.skipWhitespace(input, b)) == 34 || b == 39) {
            int endQuote = b;
            b = input.read();
            while (b != endQuote && b != -1) {
                word.append((char)b);
                b = input.read();
            }
            if (b == endQuote) {
                b = input.read();
            }
        } else {
            while (!(b == 61 && stopOnEquals || b == 62 || b == -1 || Character.isWhitespace((char)b))) {
                word.append((char)b);
                b = input.read();
            }
        }
        return b;
    }
}

