/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.hypertext.linkextractor.html;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semanticdesktop.aperture.hypertext.linkextractor.LinkExtractor;
import org.semanticdesktop.aperture.hypertext.linkextractor.html.EntityResolver;
import org.semanticdesktop.aperture.hypertext.linkextractor.html.TokenHandler;
import org.semanticdesktop.aperture.hypertext.linkextractor.html.Tokenizer;

public class HtmlLinkExtractor
implements LinkExtractor,
TokenHandler {
    private URL baseURL;
    private boolean includeEmbeddedResources;
    private ArrayList links;
    private String startTag;
    private HashMap attributes = new HashMap();

    public synchronized List extractLinks(InputStream inputStream, Map params) throws IOException {
        Tokenizer tokenizer = new Tokenizer(this);
        this.links = new ArrayList();
        this.baseURL = null;
        this.includeEmbeddedResources = false;
        Object value = params.get(BASE_URL_KEY);
        if (value instanceof URL) {
            this.baseURL = (URL)value;
        } else if (value instanceof String) {
            this.baseURL = new URL((String)value);
        }
        value = params.get(INCLUDE_EMBEDDED_RESOURCES_KEY);
        if (value instanceof Boolean) {
            this.includeEmbeddedResources = (Boolean)value;
        }
        tokenizer.read(inputStream);
        ArrayList result = this.links;
        this.links = null;
        return result;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startOfStartTag(String name) {
        this.startTag = name.toUpperCase();
    }

    public void endOfStartTag() {
        ArrayList<String> localLinks = new ArrayList<String>();
        if ("BASE".equals(this.startTag)) {
            String href = (String)this.attributes.get("HREF");
            if (href != null) {
                try {
                    this.baseURL = new URL(href);
                }
                catch (MalformedURLException e) {}
            }
        } else if ("META".equals(this.startTag)) {
            String content = (String)this.attributes.get("CONTENT");
            String httpEquiv = (String)this.attributes.get("HTTP-EQUIV");
            if (content != null && httpEquiv != null && httpEquiv.trim().equalsIgnoreCase("REFRESH")) {
                String contentInLC = content.toLowerCase();
                int urlIndex = contentInLC.indexOf("url");
                if (urlIndex != -1) {
                    urlIndex += 3;
                }
                int commaIndex = contentInLC.indexOf(44);
                int semiColonIndex = contentInLC.indexOf(59);
                int maxIndex = Math.max(urlIndex, commaIndex);
                if ((maxIndex = Math.max(maxIndex, semiColonIndex)) != -1) {
                    content = content.substring(maxIndex + 1);
                }
                localLinks.add(content);
            }
        } else if ("A".equals(this.startTag)) {
            localLinks.add((String)this.attributes.get("HREF"));
        } else if ("FRAME".equals(this.startTag) || "IFRAME".equals(this.startTag)) {
            localLinks.add((String)this.attributes.get("SRC"));
            localLinks.add((String)this.attributes.get("LONGDESC"));
        } else if ("HEAD".equals(this.startTag)) {
            localLinks.add((String)this.attributes.get("PROFILE"));
        } else if ("AREA".equals(this.startTag)) {
            localLinks.add((String)this.attributes.get("HREF"));
        } else if ("Q".equals(this.startTag) || "BLOCKQUOTE".equals(this.startTag) || "INS".equals(this.startTag) || "DEL".equals(this.startTag)) {
            localLinks.add((String)this.attributes.get("CITE"));
        } else if ("LINK".equals(this.startTag)) {
            if (this.includeEmbeddedResources) {
                localLinks.add((String)this.attributes.get("HREF"));
                localLinks.add((String)this.attributes.get("SRC"));
            }
        } else if ("LAYER".equals(this.startTag) || "ILAYER".equals(this.startTag)) {
            localLinks.add((String)this.attributes.get("SRC"));
            if (this.includeEmbeddedResources) {
                localLinks.add((String)this.attributes.get("BACKGROUND"));
            }
        } else if ("BODY".equals(this.startTag) || "TABLE".equals(this.startTag) || "TR".equals(this.startTag) || "TH".equals(this.startTag) || "TD".equals(this.startTag)) {
            if (this.includeEmbeddedResources) {
                localLinks.add((String)this.attributes.get("BACKGROUND"));
            }
        } else if ("IMG".equals(this.startTag)) {
            if (this.includeEmbeddedResources) {
                localLinks.add((String)this.attributes.get("SRC"));
                localLinks.add((String)this.attributes.get("LOWSRC"));
            }
            localLinks.add((String)this.attributes.get("LONGDESC"));
            localLinks.add((String)this.attributes.get("USEMAP"));
        } else if ("INPUT".equals(this.startTag)) {
            if (this.includeEmbeddedResources) {
                localLinks.add((String)this.attributes.get("SRC"));
            }
            localLinks.add((String)this.attributes.get("USEMAP"));
        }
        int nrLinks = localLinks.size();
        for (int i = 0; i < nrLinks; ++i) {
            String link = (String)localLinks.get(i);
            if (link == null) continue;
            link = EntityResolver.resolveEntities(link);
            if (this.baseURL != null) {
                try {
                    URL url = new URL(this.baseURL, link);
                    link = url.toExternalForm();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            this.links.add(link);
        }
        this.attributes.clear();
    }

    public void endTag(String name) {
    }

    public void attribute(String name) {
    }

    public void attribute(String name, String value) {
        this.attributes.put(name.toUpperCase(), value);
    }

    public void text(String text) {
    }

    public void comment(String comment) {
    }

    public void docType(String name, String sysId, String fpi, String uri) {
    }

    public void error(String message) {
    }
}

