/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.wordperfect;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.corel.util.WPStringExtractor;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;

public class WordPerfectExtractor
implements Extractor {
    public void extract(URI id, InputStream stream, Charset charset, String mimeType, RDFContainer result) throws ExtractorException {
        try {
            WPStringExtractor extractor = new WPStringExtractor();
            String text = extractor.extract(stream).trim();
            if (text.length() > 0) {
                result.add(NIE.plainTextContent, text);
                result.add(RDF.type, NFO.PaginatedTextDocument);
            }
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
    }
}

