/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.util;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.StreamMonitor;

public class ThreadedExtractorWrapper
implements Extractor {
    public static final long DEFAULT_MAX_PROCESSING_TIME_PER_MB = 10000L;
    public static final long DEFAULT_MINIMUM_MAX_PROCESSING_TIME = 30000L;
    public static final long DEFAULT_MAX_IDLE_READ_TIME = 30000L;
    private Extractor extractor;
    private boolean stopRequested;
    private long maxProcessingTimePerMb = 10000L;
    private long minimumMaxProcessingTime = 30000L;
    private long maxIdleReadTime = 30000L;

    public ThreadedExtractorWrapper(Extractor extractor) {
        this.extractor = extractor;
        this.stopRequested = false;
    }

    public ThreadedExtractorWrapper(Extractor extractor, long maxProcessingTimePerMb, long minimumMaxProcessingTime, long maxIdleReadTime) {
        this.extractor = extractor;
        this.stopRequested = false;
        this.maxProcessingTimePerMb = maxProcessingTimePerMb;
        this.minimumMaxProcessingTime = minimumMaxProcessingTime;
        this.maxIdleReadTime = maxIdleReadTime;
    }

    public void stop() {
        this.stopRequested = true;
    }

    public void extract(final URI id, InputStream input, final Charset charset, final String mimeType, final RDFContainer result) throws ExtractorException {
        StreamMonitor monitor = new StreamMonitor(input, new StreamMonitor.StreamConsumerFactory(){

            public StreamMonitor.StreamConsumer getConsumer(InputStream stream, StreamMonitor stMonitor) {
                return new ExtractionThread(id, stream, charset, mimeType, result);
            }
        }, new StreamMonitor.StopRequestor(){

            public boolean isStopRequested() {
                return ThreadedExtractorWrapper.this.stopRequested;
            }
        }, this.maxProcessingTimePerMb, this.minimumMaxProcessingTime, this.maxIdleReadTime);
        try {
            monitor.start();
        }
        catch (Exception e) {
            if (e instanceof ExtractorException) {
                throw (ExtractorException)e;
            }
            if (e instanceof StreamMonitor.ProcessingAbortedException) {
                throw new ExtractionAbortedException();
            }
            if (e instanceof StreamMonitor.ProcessingInterruptedException) {
                throw new ExtractionInterruptedException();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ExtractorException(e);
        }
    }

    private class ExtractionThread
    extends StreamMonitor.StreamConsumer {
        private URI id;
        private InputStream input;
        private Charset charset;
        private String mimeType;
        private RDFContainer result;
        private Exception exception;

        public ExtractionThread(URI id, InputStream input, Charset charset, String mimeType, RDFContainer result) {
            this.id = id;
            this.input = input;
            this.charset = charset;
            this.mimeType = mimeType;
            this.result = result;
        }

        public void run() {
            try {
                ThreadedExtractorWrapper.this.extractor.extract(this.id, this.input, this.charset, this.mimeType, this.result);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public void abortProcessing() {
            this.interrupt();
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class ExtractionAbortedException
    extends ExtractorException {
        private static final long serialVersionUID = -1806199350296089459L;

        public ExtractionAbortedException() {
            super("Extraction has been aborted due to problems with the extractor");
        }
    }

    public static class ExtractionInterruptedException
    extends ExtractorException {
        private static final long serialVersionUID = -4052987146699550288L;

        public ExtractionInterruptedException() {
            super("Extraction interrupted upon request");
        }
    }
}

