/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtfExtractor
implements Extractor {
    public void extract(URI id, InputStream stream, Charset charset, String mimeType, RDFContainer result) throws ExtractorException {
        RTFEditorKit rtfParser = new RTFEditorKit();
        Document document = rtfParser.createDefaultDocument();
        try {
            rtfParser.read(stream, document, 0);
            String text = document.getText(0, document.getLength());
            result.add(NIE.plainTextContent, text);
            result.add(RDF.type, NFO.TextDocument);
        }
        catch (BadLocationException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.warn("Bad RTF location", e);
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
    }
}

