/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.quattro;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.microsoft.util.PoiUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuattroExtractor
implements Extractor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final byte[] MAGIC_BYTES = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};

    public void extract(URI id, InputStream stream, Charset charset, String mimeType, RDFContainer result) throws ExtractorException {
        try {
            if (!stream.markSupported()) {
                stream = new BufferedInputStream(stream, MAGIC_BYTES.length);
            }
            if (this.hasMSOfficeMagicNumber(stream)) {
                PoiUtil.extractAll(stream, null, result, this.logger);
            }
            result.add(RDF.type, NFO.Spreadsheet);
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
    }

    private boolean hasMSOfficeMagicNumber(InputStream stream) throws IOException {
        int length = MAGIC_BYTES.length;
        stream.mark(length);
        byte[] bytes = IOUtil.readBytes(stream, length);
        stream.reset();
        return Arrays.equals(bytes, MAGIC_BYTES);
    }
}

