/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.presentations;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.corel.util.WPStringExtractor;
import org.semanticdesktop.aperture.extractor.microsoft.util.PoiUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresentationsExtractor
implements Extractor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final byte[] OFFICE_MAGIC_BYTES = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] WORDPERFECT_MAGIC_BYTES = new byte[]{-1, 87, 80, 67};

    public void extract(URI id, InputStream stream, Charset charset, String mimeType, RDFContainer result) throws ExtractorException {
        try {
            PresentationsWPStringExtractor extractor;
            String text;
            int length = Math.max(OFFICE_MAGIC_BYTES.length, WORDPERFECT_MAGIC_BYTES.length);
            if (!stream.markSupported()) {
                stream = new BufferedInputStream(stream, length);
            }
            stream.mark(length);
            byte[] bytes = IOUtil.readBytes(stream, length);
            stream.reset();
            if (this.hasMagicNumber(bytes, OFFICE_MAGIC_BYTES)) {
                stream = PoiUtil.extractAll(stream, null, result, this.logger);
            } else if (this.hasMagicNumber(bytes, WORDPERFECT_MAGIC_BYTES) && (text = (extractor = new PresentationsWPStringExtractor()).extract(stream).trim()).length() > 0) {
                result.add(NIE.plainTextContent, text);
            }
            result.add(RDF.type, NFO.Presentation);
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
    }

    private boolean hasMagicNumber(byte[] bytes, byte[] magicNumber) {
        if (bytes.length < magicNumber.length) {
            return false;
        }
        for (int i = 0; i < magicNumber.length; ++i) {
            if (bytes[i] == magicNumber[i]) continue;
            return false;
        }
        return true;
    }

    private static class PresentationsWPStringExtractor
    extends WPStringExtractor {
        private static final String[] EXCLUDES = new String[]{"title of show", "subtitle of show", "subitem", "first item", "second item", "third item", "fourth item", "title of slide", "subtitle of slide", "north", "south", "east", "west", "this is the first item.  this is the second item.", "this is the third item.  this is the fourth item.", "click to edit master title style", "click to edit master subtitle", "click to edit master text styles", "footer area", "first level", "second level", "third level", "fourth level", "fifth level"};

        private PresentationsWPStringExtractor() {
        }

        protected boolean isValidLine(String lineLowerCase) {
            for (int i = 0; i < EXCLUDES.length; ++i) {
                if (!lineLowerCase.equals(EXCLUDES[i])) continue;
                return false;
            }
            return super.isValidLine(lineLowerCase);
        }
    }
}

