/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.mp3;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.AbstractFileExtractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.mp3.FrameIdentifier;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NID3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MP3FileExtractor
extends AbstractFileExtractor {
    private Logger logger = LoggerFactory.getLogger(MP3FileExtractor.class);

    @Override
    protected void performExtraction(URI id, File file, Charset charset, String mimeType, RDFContainer result) throws ExtractorException {
        MP3File mp3File = null;
        try {
            mp3File = new MP3File(file);
        }
        catch (FileNotFoundException e) {
            throw new ExtractorException(e);
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
        catch (TagException e) {
            throw new ExtractorException("File format not supported by the MP3Exctractor: " + file.getParent(), e);
        }
        catch (ReadOnlyFileException e) {
            throw new ExtractorException(e);
        }
        catch (InvalidAudioFrameException e) {
            throw new ExtractorException(e);
        }
        HashMap<URI, String> id3v1hashMap = new HashMap<URI, String>();
        if (mp3File.hasID3v1Tag()) {
            this.processID3V1Tags(id, mp3File, charset, mimeType, id3v1hashMap);
        }
        if (mp3File.hasID3v2Tag()) {
            this.processID3V2Tags(id, mp3File, charset, mimeType, id3v1hashMap, result);
        }
        this.addId3V1Fields(id3v1hashMap, result);
        result.add(RDF.type, NID3.ID3Audio);
    }

    private void processID3V1Tags(URI id, MP3File mp3File, Charset charset, String mimeType, HashMap<URI, String> resultHashMap) {
        ID3v1Tag id3v1 = mp3File.getID3v1Tag();
        this.addStringProperty(NID3.title, id3v1.getFirstTitle(), resultHashMap);
        this.addStringProperty(NID3.leadArtist, id3v1.getFirstArtist(), resultHashMap);
        this.addStringProperty(NID3.albumTitle, id3v1.getFirstAlbum(), resultHashMap);
        this.addStringProperty(NID3.recordingYear, id3v1.getFirstYear(), resultHashMap);
        this.addStringProperty(NID3.comments, id3v1.getFirstComment(), resultHashMap);
        this.addStringProperty(NID3.contentType, id3v1.getFirstGenre(), resultHashMap);
        if (id3v1 instanceof ID3v11Tag) {
            ID3v11Tag id3v1_1 = (ID3v11Tag)id3v1;
            this.addStringProperty(NID3.trackNumber, id3v1_1.getFirstTrack(), resultHashMap);
        }
    }

    private void processID3V2Tags(URI id, MP3File mp3File, Charset charset, String mimeType, HashMap<URI, String> id3v1FieldHashMap, RDFContainer result) {
        AbstractID3v2Tag id3v2 = mp3File.getID3v2Tag();
        Iterator iterator = id3v2.getFields();
        while (iterator.hasNext()) {
            AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
            String identifier = frame.getIdentifier();
            try {
                FrameIdentifier frameIdentifier = FrameIdentifier.valueOf(identifier.trim());
                AbstractTagFrameBody body = frame.getBody();
                frameIdentifier.process(body, id3v2, id3v1FieldHashMap, result);
            }
            catch (Exception e) {
                this.logger.warn("Problem while getting the frame '" + identifier + "' from file " + id, e);
            }
        }
    }

    private void addStringProperty(URI property, String string, HashMap<URI, String> resultHashMap) {
        if (string != null && string.length() > 0) {
            resultHashMap.put(property, string);
        }
    }

    private void addId3V1Fields(HashMap<URI, String> id3v1hashMap, RDFContainer result) {
        for (Map.Entry<URI, String> entry : id3v1hashMap.entrySet()) {
            URI uri = entry.getKey();
            String value = entry.getValue();
            if (uri.equals(NID3.recordingYear)) {
                try {
                    int intValue = Integer.parseInt(value);
                    result.add(uri, intValue);
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if (uri.equals(NID3.leadArtist)) {
                Model model = result.getModel();
                Resource anonymousContact = ModelUtil.generateRandomResource(model);
                model.addStatement(result.getDescribedUri(), NID3.leadArtist, anonymousContact);
                model.addStatement(anonymousContact, RDF.type, NCO.Contact);
                model.addStatement(anonymousContact, NCO.fullname, value);
                continue;
            }
            result.add(uri, value);
        }
    }
}

