/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.mime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.mime.MailUtil;
import org.semanticdesktop.aperture.helper.html.HtmlParserException;
import org.semanticdesktop.aperture.helper.html.HtmlParserUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NMO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeExtractor
implements Extractor {
    public void extract(URI id, InputStream stream, Charset charset, String mimeType, RDFContainer result) throws ExtractorException {
        try {
            String title;
            MimeMessage message = new MimeMessage(null, stream);
            result.add(RDF.type, NMO.Email);
            StringBuilder buffer = new StringBuilder(10000);
            this.processContent(message.getContent(), buffer);
            String text = buffer.toString().trim();
            if (text.length() > 0) {
                result.add(NMO.plainTextMessageContent, text);
            }
            if ((title = message.getSubject()) != null && (title = title.trim()).length() > 0) {
                result.add(NMO.messageSubject, title);
            }
            try {
                this.copyAddress(message.getFrom(), NMO.from, result);
            }
            catch (AddressException e) {
                // empty catch block
            }
            this.copyAddress(this.getRecipients(message, Message.RecipientType.TO), NMO.to, result);
            this.copyAddress(this.getRecipients(message, Message.RecipientType.CC), NMO.cc, result);
            this.copyAddress(this.getRecipients(message, Message.RecipientType.BCC), NMO.bcc, result);
            MailUtil.getDates(message, result);
        }
        catch (MessagingException e) {
            throw new ExtractorException(e);
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
    }

    private void processContent(Object content, StringBuilder buffer) throws MessagingException, IOException {
        if (content instanceof String) {
            buffer.append(content);
            buffer.append(' ');
        } else if (content instanceof BodyPart) {
            BodyPart bodyPart = (BodyPart)content;
            String fileName = bodyPart.getFileName();
            if (fileName != null) {
                try {
                    fileName = MimeUtility.decodeWord(fileName);
                }
                catch (MessagingException e) {
                    // empty catch block
                }
                buffer.append(fileName);
                buffer.append(' ');
            }
            content = bodyPart.getContent();
            String contentType = bodyPart.getContentType();
            if (contentType != null && content instanceof String && (contentType = contentType.toLowerCase()).indexOf("text/html") >= 0) {
                content = this.extractTextFromHtml((String)content);
            }
            this.processContent(content, buffer);
        } else if (content instanceof Multipart) {
            ContentType ct;
            Multipart multipart = (Multipart)content;
            String subType = null;
            String contentType = multipart.getContentType();
            if (contentType != null && (subType = (ct = new ContentType(contentType)).getSubType()) != null) {
                subType = subType.trim().toLowerCase();
            }
            if ("alternative".equals(subType)) {
                this.handleAlternativePart(multipart, buffer);
            } else if ("signed".equals(subType)) {
                this.handleProtectedPart(multipart, 0, buffer);
            } else if ("encrypted".equals(subType)) {
                this.handleProtectedPart(multipart, 1, buffer);
            } else {
                this.handleMixedPart(multipart, buffer);
            }
        }
    }

    private void handleAlternativePart(Multipart multipart, StringBuilder buffer) throws MessagingException, IOException {
        Object content;
        boolean isHtml = false;
        int idx = this.getPartWithMimeType(multipart, "text/plain");
        if (idx < 0) {
            idx = this.getPartWithMimeType(multipart, "text/html");
            isHtml = true;
        }
        if (idx >= 0 && (content = multipart.getBodyPart(idx).getContent()) != null) {
            if (content instanceof String && isHtml) {
                content = this.extractTextFromHtml((String)content);
            }
            this.processContent(content, buffer);
        }
    }

    private void handleMixedPart(Multipart multipart, StringBuilder buffer) throws MessagingException, IOException {
        int count = multipart.getCount();
        for (int i = 0; i < count; ++i) {
            this.processContent(multipart.getBodyPart(i), buffer);
        }
    }

    private void handleProtectedPart(Multipart multipart, int index, StringBuilder buffer) throws MessagingException, IOException {
        if (index < multipart.getCount()) {
            this.processContent(multipart.getBodyPart(index), buffer);
        }
    }

    private int getPartWithMimeType(Multipart multipart, String mimeType) throws MessagingException {
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            if (!mimeType.equalsIgnoreCase(this.getMimeType(bodyPart))) continue;
            return i;
        }
        return -1;
    }

    private String getMimeType(Part mailPart) throws MessagingException {
        String contentType = mailPart.getContentType();
        if (contentType != null) {
            ContentType ct = new ContentType(contentType);
            return ct.getBaseType();
        }
        return null;
    }

    private String extractTextFromHtml(String string) {
        HtmlParserUtil.ContentExtractor extractor = new HtmlParserUtil.ContentExtractor();
        ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes());
        try {
            HtmlParserUtil.parse(stream, null, extractor);
        }
        catch (HtmlParserException e) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(32768);
        this.append(buffer, extractor.getTitle());
        this.append(buffer, extractor.getAuthor());
        this.append(buffer, extractor.getDescription());
        Iterator keywords = extractor.getKeywords();
        while (keywords.hasNext()) {
            this.append(buffer, (String)keywords.next());
        }
        this.append(buffer, extractor.getText());
        return buffer.toString();
    }

    private void append(StringBuilder buffer, String text) {
        if (text != null) {
            buffer.append(text);
            buffer.append(' ');
        }
    }

    private Address[] getRecipients(MimeMessage message, Message.RecipientType type) throws MessagingException {
        Address[] result = null;
        try {
            result = message.getRecipients(type);
        }
        catch (AddressException e) {
            // empty catch block
        }
        return result;
    }

    private void copyAddress(Object address, URI predicate, RDFContainer result) {
        try {
            if (address instanceof InternetAddress) {
                MailUtil.addAddressMetadata((InternetAddress)address, predicate, result);
            } else if (address instanceof InternetAddress[]) {
                InternetAddress[] array = (InternetAddress[])address;
                for (int i = 0; i < array.length; ++i) {
                    MailUtil.addAddressMetadata(array[i], predicate, result);
                }
            }
        }
        catch (ModelException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("ModelException while adding address metadata", e);
        }
    }
}

