/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.microsoft.util;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.util.StringExtractor;
import org.semanticdesktop.aperture.vocabulary.APERTURE_NIE_EXTENSIONS;
import org.semanticdesktop.aperture.vocabulary.NAO;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;

public class PoiUtil {
    private static final String BUFFER_SIZE_PROPERTY = "aperture.poiUtil.bufferSize";
    private static final int DEFAULT_BUFFER_SIZE = 0x400000;

    public static SummaryInformation getSummaryInformation(POIFSFileSystem poiFileSystem) {
        return PoiUtil.getSummaryInformation(poiFileSystem.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SummaryInformation getSummaryInformation(DirectoryNode dirNode) {
        SummaryInformation summaryInformation;
        DocumentInputStream docInputStream = dirNode.createDocumentInputStream("\u0005SummaryInformation");
        try {
            summaryInformation = (SummaryInformation)PropertySetFactory.create((InputStream)docInputStream);
        }
        catch (Throwable throwable) {
            try {
                docInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        docInputStream.close();
        return summaryInformation;
    }

    public static DocumentSummaryInformation getDocumentSummaryInformation(POIFSFileSystem poiFileSystem) {
        return PoiUtil.getDocumentSummaryInformation(poiFileSystem.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentSummaryInformation getDocumentSummaryInformation(DirectoryNode dirNode) {
        DocumentSummaryInformation documentSummaryInformation;
        DocumentInputStream docInputStream = dirNode.createDocumentInputStream("\u0005DocumentSummaryInformation");
        try {
            documentSummaryInformation = (DocumentSummaryInformation)PropertySetFactory.create((InputStream)docInputStream);
        }
        catch (Throwable throwable) {
            try {
                docInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        docInputStream.close();
        return documentSummaryInformation;
    }

    public static InputStream extractMetadata(InputStream stream, boolean resetStream, RDFContainer container) throws IOException {
        if (resetStream) {
            int bufferSize = PoiUtil.getBufferSize();
            if (!stream.markSupported()) {
                stream = new BufferedInputStream(stream, bufferSize);
            }
            stream.mark(bufferSize);
        }
        POIFSFileSystem fileSystem = new POIFSFileSystem((InputStream)new NonCloseableStream(stream));
        PoiUtil.extractMetadata(fileSystem, container);
        if (resetStream) {
            stream.reset();
        }
        return stream;
    }

    public static void extractMetadata(POIFSFileSystem poiFileSystem, RDFContainer container) {
        PoiUtil.extractMetadata(poiFileSystem.getRoot(), container);
    }

    public static void extractMetadata(DirectoryNode dirNode, RDFContainer container) {
        DocumentSummaryInformation docSummary;
        SummaryInformation summary = PoiUtil.getSummaryInformation(dirNode);
        if (summary != null) {
            long editTime;
            int nrWords;
            int nrChars;
            PoiUtil.copyString(summary.getTitle(), NIE.title, container);
            PoiUtil.copyString(summary.getSubject(), NIE.subject, container);
            PoiUtil.copyString(summary.getComments(), NIE.description, container);
            PoiUtil.copyString(summary.getApplicationName(), NIE.generator, container);
            PoiUtil.copyContact(summary.getAuthor(), NCO.creator, container);
            PoiUtil.copyContact(summary.getLastAuthor(), NCO.contributor, container);
            PoiUtil.copyDate(summary.getCreateDateTime(), NIE.contentCreated, container);
            PoiUtil.copyDate(summary.getLastSaveDateTime(), NIE.contentLastModified, container);
            PoiUtil.copyDate(summary.getLastPrinted(), APERTURE_NIE_EXTENSIONS.contentLastPrinted, container);
            PoiUtil.copyString(summary.getRevNumber(), NIE.version, container);
            int nrPages = summary.getPageCount();
            if (nrPages > 1) {
                container.add(RDF.type, NFO.PaginatedTextDocument);
                container.add(NFO.pageCount, nrPages);
            }
            if ((nrChars = summary.getCharCount()) > 0) {
                container.add(NFO.characterCount, nrChars);
            }
            if ((nrWords = summary.getWordCount()) > 0) {
                container.add(NFO.wordCount, nrWords);
            }
            if ((editTime = summary.getEditTime()) > 0L) {
                container.add(APERTURE_NIE_EXTENSIONS.editTime, editTime /= 10000L);
            }
            PoiUtil.copyString(summary.getTemplate(), APERTURE_NIE_EXTENSIONS.template, container);
            String keywords = summary.getKeywords();
            if (keywords != null) {
                StringTokenizer tokenizer = new StringTokenizer(keywords, " \t.,;|/\\", false);
                while (tokenizer.hasMoreTokens()) {
                    String keyword = tokenizer.nextToken();
                    container.add(NIE.keyword, keyword);
                }
            }
        }
        if ((docSummary = PoiUtil.getDocumentSummaryInformation(dirNode)) != null) {
            PoiUtil.copyContact(docSummary.getManager(), NCO.contributor, container);
            PoiUtil.copyString(docSummary.getCompany(), NCO.org, container);
            PoiUtil.copyString(docSummary.getCategory(), NAO.hasTopic, container);
            int nrLines = docSummary.getLineCount();
            if (nrLines > 0) {
                container.add(NFO.lineCount, nrLines);
            }
        }
    }

    private static void copyString(String value, URI property, RDFContainer container) {
        if (value != null && (value = value.trim()).length() > 0) {
            container.add(property, value);
        }
    }

    private static void copyDate(Date date, URI property, RDFContainer container) {
        if (date != null) {
            container.add(property, date);
        }
    }

    private static void copyContact(String name, URI property, RDFContainer container) {
        if (name != null) {
            Model model = container.getModel();
            Resource resource = ModelUtil.generateRandomResource(model);
            model.addStatement(container.getDescribedUri(), property, resource);
            model.addStatement(resource, RDF.type, NCO.Contact);
            model.addStatement(resource, NCO.fullname, name);
        }
    }

    public static InputStream extractAll(InputStream stream, TextExtractor textExtractor, RDFContainer container, Logger logger) {
        int bufferSize = PoiUtil.getBufferSize();
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream, bufferSize);
        }
        stream.mark(bufferSize);
        String text = null;
        boolean encrypted = false;
        try {
            POIFSFileSystem fileSystem = new POIFSFileSystem((InputStream)new NonCloseableStream(stream));
            try {
                if (textExtractor != null) {
                    text = textExtractor.getText(fileSystem.getRoot(), fileSystem);
                }
            }
            catch (EncryptedDocumentException e) {
                encrypted = true;
                container.add(NFO.encryptionStatus, NFO.encryptedStatus);
            }
            catch (Exception e) {
                // empty catch block
            }
            PoiUtil.extractMetadata(fileSystem, container);
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (text == null && !encrypted) {
            if (textExtractor != null) {
                logger.info("regular POI-based processing failed, falling back to heuristic string extraction for " + container.getDescribedUri());
            }
            try {
                stream.reset();
                StringExtractor extractor = new StringExtractor();
                text = extractor.extract(stream);
            }
            catch (IOException e) {
                logger.warn("IOException while processing " + container.getDescribedUri(), e);
            }
        }
        if (text != null && (text = text.trim()).length() > 0) {
            container.add(NIE.plainTextContent, text);
        }
        try {
            stream.reset();
        }
        catch (Exception e) {
            // empty catch block
        }
        return stream;
    }

    public static int getBufferSize() {
        int result = 0x400000;
        String property = System.getProperty(BUFFER_SIZE_PROPERTY);
        if (property != null && !property.equals("")) {
            result = Integer.parseInt(property);
        }
        if (result < 0) {
            throw new IllegalArgumentException("Negative buffer sizes not allowed: " + result);
        }
        return result;
    }

    public static class NonCloseableStream
    extends FilterInputStream {
        public NonCloseableStream(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }

    public static interface TextExtractor {
        public String getText(DirectoryNode var1, POIFSFileSystem var2) throws IOException;
    }
}

