/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.jpg;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.GEO;
import org.semanticdesktop.aperture.vocabulary.NEXIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpgHeaderExtractor {
    private Metadata metadata = null;
    private Directory exifDirectory = null;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private URI id = null;
    private RDFContainer result = null;
    private Directory iptcDirectory;
    private Directory gpsDirectory;
    private NumberFormat degreesFormat;

    public JpgHeaderExtractor(URI id, InputStream jpegFile, RDFContainer result) {
        this.id = id;
        this.result = result;
        DecimalFormatSymbols sym = new DecimalFormatSymbols(Locale.US);
        this.degreesFormat = new DecimalFormat("0.#########", sym);
        try {
            this.metadata = JpegMetadataReader.readMetadata((InputStream)jpegFile);
            this.exifDirectory = this.metadata.getDirectory(ExifDirectory.class);
            this.iptcDirectory = this.metadata.getDirectory(IptcDirectory.class);
            this.gpsDirectory = this.metadata.getDirectory(GpsDirectory.class);
        }
        catch (JpegProcessingException e) {
            this.logger.warn("error extracting metadata", e);
        }
    }

    public void extractExif() {
        if (this.exifDirectory == null) {
            return;
        }
        this.addStringMetadataIfSet(37378, NEXIF.apertureValue, this.exifDirectory);
        this.addStringMetadataIfSet(315, NEXIF.artist, this.exifDirectory);
        this.addStringMetadataIfSet(258, NEXIF.bitsPerSample, this.exifDirectory);
        this.addStringMetadataIfSet(37379, NEXIF.brightnessValue, this.exifDirectory);
        this.addStringMetadataIfSet(33432, NEXIF.copyright, this.exifDirectory);
        this.addStringMetadataIfSet(40963, NEXIF.height, this.exifDirectory);
        this.addStringMetadataIfSet(40962, NEXIF.width, this.exifDirectory);
        this.addStringMetadataIfSet(37380, NEXIF.exposureBiasValue, this.exifDirectory);
        this.addStringMetadataIfSet(41493, NEXIF.exposureIndex, this.exifDirectory);
        this.addStringMetadataIfSet(41986, NEXIF.exposureMode, this.exifDirectory);
        this.addStringMetadataIfSet(34850, NEXIF.exposureProgram, this.exifDirectory);
        this.addStringMetadataIfSet(34850, NEXIF.exposureProgram, this.exifDirectory);
        this.addStringMetadataIfSet(33434, NEXIF.exposureTime, this.exifDirectory);
        this.addStringMetadataIfSet(37385, NEXIF.flash, this.exifDirectory);
        this.addStringMetadataIfSet(37387, NEXIF.flashEnergy, this.exifDirectory);
        this.addStringMetadataIfSet(40960, NEXIF.flashpixVersion, this.exifDirectory);
        this.addStringMetadataIfSet(271, NEXIF.make, this.exifDirectory);
    }

    private void addStringMetadataIfSet(int tag, URI property, Directory directory) {
        String entry = directory.getString(tag);
        if (entry != null) {
            this.result.add(property, entry);
        }
    }

    private double getRationalArrayValue(int tag, Directory directory) {
        if (!directory.containsTag(tag)) {
            return Double.NaN;
        }
        try {
            Rational[] rationalArray = directory.getRationalArray(tag);
            double resultDouble = rationalArray[0].doubleValue() + rationalArray[1].doubleValue() / 60.0 + rationalArray[2].doubleValue() / 3600.0;
            return resultDouble;
        }
        catch (MetadataException e) {
            return Double.NaN;
        }
    }

    public void extractIPTC() {
    }

    public void extractGPS() {
        String ref;
        if (this.gpsDirectory == null) {
            return;
        }
        String longitude = this.gpsDirectory.getString(4);
        String latitude = this.gpsDirectory.getString(2);
        String altitude = this.gpsDirectory.getString(6);
        if (longitude == null && latitude == null && altitude == null) {
            return;
        }
        Model model = this.result.getModel();
        Resource point = ModelUtil.generateRandomResource(model);
        this.result.add(NEXIF.gps, point);
        model.addStatement(point, RDF.type, GEO.Point);
        if (altitude != null) {
            double alt = this.getRationalArrayValue(6, this.gpsDirectory);
            model.addStatement(point, GEO.alt, this.degreesFormat.format(alt));
        }
        if (longitude != null) {
            double lon = this.getRationalArrayValue(4, this.gpsDirectory);
            ref = this.gpsDirectory.getString(3);
            if (ref != null && ref.equalsIgnoreCase("W")) {
                lon = -lon;
            }
            model.addStatement(point, GEO.long_, this.degreesFormat.format(lon));
        }
        if (latitude != null) {
            double lat = this.getRationalArrayValue(2, this.gpsDirectory);
            ref = this.gpsDirectory.getString(1);
            if (ref != null && ref.equalsIgnoreCase("S")) {
                lat = -lat;
            }
            model.addStatement(point, GEO.lat, this.degreesFormat.format(lat));
        }
    }
}

