/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.semanticdesktop.aperture.extractor.ExtractorFactory;
import org.semanticdesktop.aperture.extractor.ExtractorRegistry;
import org.semanticdesktop.aperture.extractor.FileExtractorFactory;

public class ExtractorRegistryImpl
implements ExtractorRegistry {
    private HashMap extractorFactories = new HashMap();
    private HashMap fileExtractorFactories = new HashMap();

    public void add(ExtractorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String mimeType : factory.getSupportedMimeTypes()) {
            HashSet<ExtractorFactory> factorySet = (HashSet<ExtractorFactory>)this.extractorFactories.get(mimeType);
            if (factorySet == null) {
                factorySet = new HashSet<ExtractorFactory>();
                this.extractorFactories.put(mimeType, factorySet);
            }
            factorySet.add(factory);
        }
    }

    public void add(FileExtractorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String mimeType : factory.getSupportedMimeTypes()) {
            HashSet<FileExtractorFactory> factorySet = (HashSet<FileExtractorFactory>)this.fileExtractorFactories.get(mimeType);
            if (factorySet == null) {
                factorySet = new HashSet<FileExtractorFactory>();
                this.fileExtractorFactories.put(mimeType, factorySet);
            }
            factorySet.add(factory);
        }
    }

    public void remove(ExtractorFactory factory) {
        for (String mimeType : factory.getSupportedMimeTypes()) {
            Set factorySet = (Set)this.extractorFactories.get(mimeType);
            if (factorySet == null) continue;
            factorySet.remove(factory);
            if (!factorySet.isEmpty()) continue;
            this.extractorFactories.remove(mimeType);
        }
    }

    public void remove(FileExtractorFactory factory) {
        for (String mimeType : factory.getSupportedMimeTypes()) {
            Set factorySet = (Set)this.fileExtractorFactories.get(mimeType);
            if (factorySet == null) continue;
            factorySet.remove(factory);
            if (!factorySet.isEmpty()) continue;
            this.fileExtractorFactories.remove(mimeType);
        }
    }

    public Set get(String mimeType) {
        return this.getExtractorFactories(mimeType);
    }

    public Set getExtractorFactories(String mimeType) {
        Set factorySet = (Set)this.extractorFactories.get(mimeType);
        if (factorySet == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(factorySet);
    }

    public Set getAll() {
        return this.getAllExtractorFactories();
    }

    public Set getAllExtractorFactories() {
        HashSet result = new HashSet();
        for (Set factorySet : this.extractorFactories.values()) {
            result.addAll(factorySet);
        }
        return result;
    }

    public Set getAllFileExtractorFactories() {
        HashSet result = new HashSet();
        for (Set factorySet : this.fileExtractorFactories.values()) {
            result.addAll(factorySet);
        }
        return result;
    }

    public Set getFileExtractorFactories(String mimeType) {
        Set factorySet = (Set)this.fileExtractorFactories.get(mimeType);
        if (factorySet == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(factorySet);
    }
}

