/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.html;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.helper.html.HtmlParserException;
import org.semanticdesktop.aperture.helper.html.HtmlParserUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;

public class HtmlExtractor
implements Extractor {
    public void extract(URI id, InputStream stream, Charset charset, String mimeType, RDFContainer result) throws ExtractorException {
        if (charset == null && result.getString(NIE.characterSet) != null) {
            try {
                charset = Charset.forName(result.getString(NIE.characterSet));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            HtmlParserUtil.parse(stream, charset, new TextAndMetadataExtractor(result));
        }
        catch (HtmlParserException e) {
            throw new ExtractorException(e);
        }
    }

    private static class TextAndMetadataExtractor
    extends HtmlParserUtil.ContentExtractor {
        private RDFContainer container;

        public TextAndMetadataExtractor(RDFContainer container) {
            this.container = container;
        }

        public void finishedParsing() {
            this.container.add(RDF.type, NFO.HtmlDocument);
            this.container.add(NIE.plainTextContent, this.getText());
            Iterator keywords = this.getKeywords();
            while (keywords.hasNext()) {
                this.addProperty(NIE.keyword, (String)keywords.next());
            }
            this.addProperty(NIE.title, this.getTitle());
            this.addContactProperty(NCO.creator, this.getAuthor());
            this.addProperty(NIE.description, this.getDescription());
        }

        private void addContactProperty(URI property, String fullname) {
            if (fullname != null) {
                fullname = fullname.trim();
                Model model = this.container.getModel();
                Resource contactResource = ModelUtil.generateRandomResource(model);
                model.addStatement(contactResource, RDF.type, NCO.Contact);
                model.addStatement(contactResource, NCO.fullname, fullname);
                this.container.add(property, contactResource);
            }
        }

        private void addProperty(URI property, String value) {
            if (value != null && (value = value.trim()).length() > 0) {
                this.container.add(property, value);
            }
        }
    }
}

