/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.detector.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticdesktop.aperture.detector.DataSourceDetector;
import org.semanticdesktop.aperture.detector.impl.DataSourceDetectorRegistryImpl;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DefaultDataSourceDetectorRegistry
extends DataSourceDetectorRegistryImpl {
    private static final String DEFAULT_FILE = "org/semanticdesktop/aperture/detector/impl/defaults.xml";
    private static final String TAG = "dataSourceDetector";
    private static final String NAME_TAG = "name";

    public DefaultDataSourceDetectorRegistry() {
        try {
            InputStream stream = ResourceUtil.getInputStream(DEFAULT_FILE, DefaultDataSourceDetectorRegistry.class);
            BufferedInputStream buffer = new BufferedInputStream(stream);
            this.parse(buffer);
            buffer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("unable to parse org/semanticdesktop/aperture/detector/impl/defaults.xml", e);
        }
    }

    public DefaultDataSourceDetectorRegistry(InputStream stream) throws IOException {
        this.parse(stream);
    }

    private void parse(InputStream stream) throws IOException {
        try {
            SimpleSAXParser parser = new SimpleSAXParser();
            parser.setListener(new DataSourceDetectorParser());
            parser.parse(stream);
        }
        catch (ParserConfigurationException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (SAXException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    private class DataSourceDetectorParser
    extends SimpleSAXAdapter {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private boolean insideFactoryElement = false;

        private DataSourceDetectorParser() {
        }

        public void startTag(String tagName, Map atts, String text) throws SAXException {
            if (DefaultDataSourceDetectorRegistry.TAG.equals(tagName)) {
                this.insideFactoryElement = true;
            } else if (DefaultDataSourceDetectorRegistry.NAME_TAG.equals(tagName) && this.insideFactoryElement && text != null) {
                this.processClassName(text);
            }
        }

        public void endTag(String tagName) {
            if (DefaultDataSourceDetectorRegistry.TAG.equals(tagName)) {
                this.insideFactoryElement = false;
            }
        }

        private void processClassName(String className) {
            if (!(className = className.trim()).equals("")) {
                try {
                    Class<?> clazz = Class.forName(className);
                    Object instance = clazz.newInstance();
                    DataSourceDetector detector = (DataSourceDetector)instance;
                    DefaultDataSourceDetectorRegistry.this.add(detector);
                }
                catch (ClassNotFoundException e) {
                    this.logger.warn("unable to find class " + className + ", ignoring", e);
                }
                catch (InstantiationException e) {
                    this.logger.warn("unable to instantiate class " + className + ", ignoring", e);
                }
                catch (IllegalAccessException e) {
                    this.logger.warn("unable to access class " + className + ", ignoring", e);
                }
                catch (ClassCastException e) {
                    this.logger.warn("unable to cast instance to " + DataSourceDetector.class.getName() + ", ignoring", e);
                }
            }
        }
    }
}

