/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.detector.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.detector.DataSourceDetector;
import org.semanticdesktop.aperture.detector.DataSourceDetectorRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceDetectorRegistryImpl
implements DataSourceDetectorRegistry {
    private HashMap<URI, Set<DataSourceDetector>> registry = new HashMap();

    @Override
    public void add(DataSourceDetector detector) {
        if (detector == null) {
            throw new IllegalArgumentException("detector is not allowed to be null");
        }
        URI type = detector.getSupportedType();
        Set<DataSourceDetector> set = this.registry.get(type);
        if (set == null) {
            set = new HashSet<DataSourceDetector>();
            this.registry.put(type, set);
        }
        set.add(detector);
    }

    @Override
    public void remove(DataSourceDetector detector) {
        URI type = detector.getSupportedType();
        Set<DataSourceDetector> set = this.registry.get(type);
        if (set != null) {
            set.remove(detector);
            if (set.isEmpty()) {
                this.registry.remove(type);
            }
        }
    }

    @Override
    public Set<DataSourceDetector> get(URI type) {
        Set<DataSourceDetector> set = this.registry.get(type);
        if (set == null) {
            return Collections.emptySet();
        }
        return new HashSet<DataSourceDetector>(set);
    }

    @Override
    public Set<DataSourceDetector> getAll() {
        HashSet<DataSourceDetector> result = new HashSet<DataSourceDetector>();
        for (Set<DataSourceDetector> set : this.registry.values()) {
            result.addAll(set);
        }
        return result;
    }
}

