/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.detector.bundle;

import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.semanticdesktop.aperture.detector.DataSourceDetector;
import org.semanticdesktop.aperture.detector.DataSourceDetectorRegistry;
import org.semanticdesktop.aperture.detector.impl.DataSourceDetectorRegistryImpl;

public class DataSourceDetectorServiceActivator
implements BundleActivator,
ServiceListener {
    private BundleContext bc = null;
    private ServiceRegistration registration;
    private DataSourceDetectorRegistry registry;

    public void start(BundleContext context) throws Exception {
        this.bc = context;
        this.registry = new DataSourceDetectorRegistryImpl();
        this.registration = this.bc.registerService(DataSourceDetectorRegistry.class.getName(), (Object)this.registry, new Hashtable());
        String filter = "(objectclass=" + DataSourceDetector.class.getName() + ")";
        this.bc.addServiceListener((ServiceListener)this, filter);
        ServiceReference[] references = this.bc.getServiceReferences(null, filter);
        for (int i = 0; references != null && i < references.length; ++i) {
            this.serviceChanged(new ServiceEvent(1, references[i]));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.bc.removeServiceListener((ServiceListener)this);
        this.registration.unregister();
        this.bc = null;
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.bc == null) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                DataSourceDetector detector = (DataSourceDetector)this.bc.getService(event.getServiceReference());
                this.registry.add(detector);
                break;
            }
            case 2: {
                DataSourceDetector detector = (DataSourceDetector)this.bc.getService(event.getServiceReference());
                this.registry.remove(detector);
                this.registry.add(detector);
                break;
            }
            case 4: {
                DataSourceDetector detector = (DataSourceDetector)this.bc.getService(event.getServiceReference());
                this.registry.remove(detector);
            }
        }
    }
}

