/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.web;

import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.datasource.config.DomainBoundableDataSource;
import org.semanticdesktop.aperture.datasource.web.WEBDS;

public class WebDataSource
extends DomainBoundableDataSource {
    public URI getType() {
        return WEBDS.WebDataSource;
    }

    public String getRootUrl() {
        return this.getConfiguration().getString(WEBDS.rootUrl);
    }

    public void setRootUrl(String rootUrl) {
        if (rootUrl == null) {
            this.getConfiguration().remove(WEBDS.rootUrl);
        } else {
            this.getConfiguration().put(WEBDS.rootUrl, rootUrl);
        }
    }

    public Boolean getIncludeEmbeddedResources() {
        return this.getConfiguration().getBoolean(WEBDS.includeEmbeddedResources);
    }

    public void setIncludeEmbeddedResources(Boolean includeEmbeddedResources) {
        if (includeEmbeddedResources == null) {
            this.getConfiguration().remove(WEBDS.includeEmbeddedResources);
        } else {
            this.getConfiguration().put(WEBDS.includeEmbeddedResources, includeEmbeddedResources);
        }
    }

    public Integer getMaximumDepth() {
        return this.getConfiguration().getInteger(WEBDS.maximumDepth);
    }

    public void setMaximumDepth(Integer maximumDepth) {
        if (maximumDepth == null) {
            this.getConfiguration().remove(WEBDS.maximumDepth);
        } else {
            this.getConfiguration().put(WEBDS.maximumDepth, maximumDepth);
        }
    }

    public Long getMaximumSize() {
        return this.getConfiguration().getLong(WEBDS.maximumSize);
    }

    public void setMaximumSize(Long maximumSize) {
        if (maximumSize == null) {
            this.getConfiguration().remove(WEBDS.maximumSize);
        } else {
            this.getConfiguration().put(WEBDS.maximumSize, maximumSize);
        }
    }
}

