/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.filesystem;

import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.datasource.config.DomainBoundableDataSource;
import org.semanticdesktop.aperture.datasource.filesystem.FILESYSTEMDS;

public class FileSystemDataSource
extends DomainBoundableDataSource {
    public URI getType() {
        return FILESYSTEMDS.FileSystemDataSource;
    }

    public String getRootFolder() {
        return this.getConfiguration().getString(FILESYSTEMDS.rootFolder);
    }

    public void setRootFolder(String rootFolder) {
        if (rootFolder == null) {
            this.getConfiguration().remove(FILESYSTEMDS.rootFolder);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.rootFolder, rootFolder);
        }
    }

    public Integer getMaximumDepth() {
        return this.getConfiguration().getInteger(FILESYSTEMDS.maximumDepth);
    }

    public void setMaximumDepth(Integer maximumDepth) {
        if (maximumDepth == null) {
            this.getConfiguration().remove(FILESYSTEMDS.maximumDepth);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.maximumDepth, maximumDepth);
        }
    }

    public Long getMaximumSize() {
        return this.getConfiguration().getLong(FILESYSTEMDS.maximumSize);
    }

    public void setMaximumSize(Long maximumSize) {
        if (maximumSize == null) {
            this.getConfiguration().remove(FILESYSTEMDS.maximumSize);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.maximumSize, maximumSize);
        }
    }

    public Boolean getIncludeHiddenResources() {
        return this.getConfiguration().getBoolean(FILESYSTEMDS.includeHiddenResources);
    }

    public void setIncludeHiddenResources(Boolean includeHiddenResources) {
        if (includeHiddenResources == null) {
            this.getConfiguration().remove(FILESYSTEMDS.includeHiddenResources);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.includeHiddenResources, includeHiddenResources);
        }
    }

    public Boolean getFollowSymbolicLinks() {
        return this.getConfiguration().getBoolean(FILESYSTEMDS.followSymbolicLinks);
    }

    public void setFollowSymbolicLinks(Boolean followSymbolicLinks) {
        if (followSymbolicLinks == null) {
            this.getConfiguration().remove(FILESYSTEMDS.followSymbolicLinks);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.followSymbolicLinks, followSymbolicLinks);
        }
    }

    public Boolean getSuppressParentChildLinks() {
        return this.getConfiguration().getBoolean(FILESYSTEMDS.suppressParentChildLinks);
    }

    public void setSuppressParentChildLinks(Boolean suppressParentChildLinks) {
        if (suppressParentChildLinks == null) {
            this.getConfiguration().remove(FILESYSTEMDS.suppressParentChildLinks);
        } else {
            this.getConfiguration().put(FILESYSTEMDS.suppressParentChildLinks, suppressParentChildLinks);
        }
    }
}

